# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

PYTHON_COMPAT=( python3_{10..13} )

inherit python-single-r1 wrapper

DESCRIPTION="Weevely is a stealth PHP web shell that simulate telnet-like console"
HOMEPAGE="https://github.com/epinna/weevely3"

if [[ ${PV} == *9999 ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/epinna/weevely3"
else
	SRC_URI="https://github.com/epinna/weevely3/archive/v${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"

	S="${WORKDIR}/weevely3-${PV}"
fi

LICENSE="GPL-3"
SLOT="0"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="${PYTHON_DEPS}"
RDEPEND="${DEPEND}
	$(python_gen_cond_dep 'dev-python/prettytable[${PYTHON_USEDEP}]
		dev-python/mako[${PYTHON_USEDEP}]
		dev-python/pyyaml[${PYTHON_USEDEP}]
		dev-python/python-dateutil[${PYTHON_USEDEP}]
		dev-python/pysocks[${PYTHON_USEDEP}]
		dev-python/pyopenssl[${PYTHON_USEDEP}]')"

pkg_setup() {
	python-single-r1_pkg_setup
}

src_prepare() {
	# cleanup
	rm -fr tests/ LICENSE || die

	python_fix_shebang "${S}"
	default
}

src_install() {
	insinto "/usr/share/${PN}"
	doins -r .

	python_optimize "${D}/usr/share/${PN}"

	make_wrapper $PN \
		"${PYTHON} /usr/share/${PN}/${PN}.py"

	doman weevely.1
	dodoc README.md CHANGELOG.md
}

# TODO: tests network is required
#src_test() {
#	${PYTHON} -m unittest discover tests/ "test_*.py" || die
#}

pkg_postinst() {
	einfo "\nSee documentation: https://github.com/epinna/weevely3/wiki/Getting-Started\n"
}
