# -*- coding: utf-8 -*-

# Key mappings for common layouts

mapping = {}

mapping['be'] = {
    " ": [44, 0],
    "!": [37, 0],
    "\"": [32, 0],
    "#": [32, 64],
    "$": [48, 0],
    "%": [52, 2],
    "&": [30, 0],
    "'": [33, 0],
    "(": [34, 0],
    ")": [45, 0],
    "*": [48, 2],
    "+": [56, 2],
    ",": [16, 0],
    "-": [46, 0],
    ".": [54, 2],
    "/": [55, 2],
    "0": [39, 2],
    "1": [30, 2],
    "2": [31, 2],
    "3": [32, 2],
    "4": [33, 2],
    "5": [34, 2],
    "6": [35, 2],
    "7": [36, 2],
    "8": [37, 2],
    "9": [38, 2],
    ":": [55, 0],
    ";": [54, 0],
    "<": [100, 0],
    "=": [56, 0],
    ">": [100, 2],
    "?": [16, 2],
    "@": [31, 64],
    "A": [20, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [51, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [4, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [29, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [26, 2],
    "[": [48, 64],
    "\\": [100, 64],
    "]": [47, 64],
    "^": [35, 64],
    "_": [46, 2],
    "`": [49, 64],
    "a": [20, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [51, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [4, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [29, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [26, 0],
    "{": [38, 64],
    "|": [30, 64],
    "}": [39, 64],
    "~": [56, 64],
    "BACKSPACE": [42, 0],
    " ": [44, 0],
    "£": [49, 2],
    "§": [35, 0],
    "°": [45, 2],
    "²": [53, 0],
    "³": [53, 2],
    "µ": [49, 0],
    "à": [39, 0],
    "ç": [38, 0],
    "è": [36, 0],
    "é": [31, 0],
    "ù": [52, 0],
    "€": [8, 64]
}

mapping['br'] = {
    " ": [44, 0],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "z": [29, 0],
    "x": [27, 0],
    "w": [26, 0],
    "y": [28, 0],
    "q": [20, 0],
    "ç": [51, 0],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "Z": [29, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Q": [20, 2],
    "Ç": [51, 2],
    "'": [53, 0],
    "!": [30, 2],
    "@": [31, 2],
    "#": [32, 2],
    "$": [33, 2],
    "%": [34, 2],
    "&": [36, 2],
    "*": [37, 2],
    "(": [38, 2],
    ")": [39, 2],
    "_": [45, 2],
    "+": [46, 2],
    "\"": [53, 2],
    "-": [45, 0],
    "=": [46, 0],
    "/": [20, 64],
    "?": [26, 64],
    "°": [8, 64],
    "[": [48, 0],
    "]": [49, 0],
    "{": [48, 2],
    "}": [49, 2],
    "\\": [100, 0],
    ",": [54, 0],
    ".": [55, 0],
    ";": [56, 0],
    "<": [54, 2],
    ">": [55, 2],
    ":": [56, 2],
    "§": [46, 64],
    "´": [47, 0],
    "~": [52, 0],
    "|": [100, 2],
    "^": [52, 2],
    "`": [47, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0]
}

mapping['ca'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [53, 0],
    "$": [33, 2],
    "%": [34, 2],
    "&": [36, 2],
    "'": [54, 2],
    "(": [38, 2],
    ")": [39, 2],
    "*": [37, 2],
    "+": [46, 2],
    ",": [54, 0],
    "-": [45, 0],
    ".": [55, 0],
    "/": [32, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [51, 2],
    ";": [51, 0],
    "<": [49, 0],
    "=": [46, 0],
    ">": [49, 2],
    "?": [35, 2],
    "@": [31, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [47, 64],
    "\\": [53, 64],
    "]": [48, 64],
    "^": [47, 0],
    "_": [45, 2],
    "`": [52, 0],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [52, 64],
    "|": [53, 2],
    "}": [49, 64],
    "~": [51, 64],
    "BACKSPACE": [42, 0],
    "¢": [33, 64],
    "£": [32, 64],
    "¤": [34, 64],
    "¦": [36, 64],
    "§": [18, 64],
    "¨": [48, 2],
    "«": [0, 2],
    "¬": [35, 64],
    "­": [55, 64],
    "¯": [53, 64],
    "°": [0, 64],
    "»": [0, 0],
    "´": [56, 64],
    "µ": [16, 64],
    "¶": [19, 64],
    "¸": [48, 0],
    "±": [30, 64],
    "²": [37, 64],
    "³": [38, 64],
    "¼": [39, 64],
    "½": [45, 64],
    "¾": [46, 64],
    "É": [56, 2],
    "é": [56, 0]
}

mapping['ch'] = {
    " ": [44, 0],
    "!": [48, 2],
    "\"": [31, 2],
    "#": [32, 64],
    "$": [49, 0],
    "%": [34, 2],
    "&": [35, 2],
    "'": [45, 0],
    "(": [37, 2],
    ")": [38, 2],
    "*": [32, 2],
    "+": [30, 2],
    ",": [54, 0],
    "-": [56, 0],
    ".": [55, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [55, 2],
    ";": [54, 2],
    "<": [100, 0],
    "=": [39, 2],
    ">": [100, 2],
    "?": [45, 2],
    "@": [31, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [29, 2],
    "Z": [28, 2],
    "[": [47, 64],
    "\\": [100, 64],
    "]": [48, 64],
    "^": [46, 0],
    "_": [56, 2],
    "`": [46, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [29, 0],
    "z": [28, 0],
    "{": [53, 64],
    "|": [36, 64],
    "}": [49, 64],
    "~": [46, 64],
    "BACKSPACE": [42, 0],
    " ": [44, 0],
    "§": [53, 0],
    "°": [53, 2],
    "Ä": [52, 2],
    "Ö": [51, 2],
    "Ü": [47, 2],
    "ß": [45, 0],
    "ä": [52, 0],
    "ö": [51, 0],
    "ü": [47, 0],
    "€": [8, 64]
}

mapping['de'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [49, 0],
    "$": [33, 2],
    "%": [34, 2],
    "&": [35, 2],
    "'": [49, 2],
    "(": [37, 2],
    ")": [38, 2],
    "*": [48, 2],
    "+": [48, 0],
    ",": [54, 0],
    "-": [56, 0],
    ".": [55, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [55, 2],
    ";": [54, 2],
    "<": [100, 0],
    "=": [39, 2],
    ">": [100, 2],
    "?": [45, 2],
    "@": [20, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [29, 2],
    "Z": [28, 2],
    "[": [37, 64],
    "\\": [45, 64],
    "]": [38, 64],
    "^": [53, 0],
    "_": [56, 2],
    "`": [46, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [29, 0],
    "z": [28, 0],
    "{": [36, 64],
    "|": [100, 64],
    "}": [39, 64],
    "~": [48, 64],
    "BACKSPACE": [42, 0],
    " ": [44, 0],
    "¤": [8, 64],
    "§": [32, 2],
    "°": [53, 2],
    "²": [31, 64],
    "³": [32, 64],
    "Ä": [52, 2],
    "Ö": [51, 2],
    "Ü": [47, 2],
    "ß": [45, 0],
    "ä": [52, 0],
    "ö": [51, 0],
    "ü": [47, 0],
    "€": [8, 64]
}

mapping['dk'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [32, 2],
    "$": [33, 64],
    "%": [34, 2],
    "&": [35, 2],
    "'": [49, 0],
    "(": [37, 2],
    ")": [38, 2],
    "*": [49, 2],
    "+": [45, 0],
    ",": [54, 0],
    "-": [56, 0],
    ".": [55, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [55, 2],
    ";": [54, 2],
    "<": [100, 0],
    "=": [39, 2],
    ">": [100, 2],
    "?": [45, 2],
    "@": [31, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [37, 64],
    "\\": [100, 64],
    "]": [38, 64],
    "_": [56, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [36, 64],
    "|": [46, 64],
    "}": [39, 64],
    "~": [48, 64],
    "BACKSPACE": [42, 0],
    " ": [44, 0],
    "£": [32, 64],
    "¤": [33, 2],
    "§": [53, 2],
    "¨": [0, 0],
    "«": [33, 0],
    "´": [0, 0],
    "µ": [16, 64],
    "½": [53, 0],
    "Å": [47, 2],
    "Æ": [51, 2],
    "Ø": [52, 2],
    "ß": [22, 64],
    "å": [47, 0],
    "æ": [51, 0],
    "ð": [7, 64],
    "ø": [52, 0],
    "þ": [23, 64],
    "€": [8, 64]
}

mapping['es'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [32, 64],
    "$": [33, 2],
    "%": [34, 2],
    "&": [35, 2],
    "'": [45, 0],
    "(": [37, 2],
    ")": [38, 2],
    "*": [48, 2],
    "+": [48, 0],
    ",": [54, 0],
    "-": [56, 0],
    ".": [55, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [55, 2],
    ";": [54, 2],
    "<": [100, 0],
    "=": [39, 2],
    ">": [100, 2],
    "?": [45, 2],
    "@": [31, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [47, 64],
    "\\": [53, 64],
    "]": [48, 64],
    "^": [46, 2],
    "_": [56, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [47, 66],
    "|": [30, 64],
    "}": [48, 66],
    "~": [33, 64],
    "º": [53, 0],
    "à": [52, 0],
    "è": [47, 0],
    "é": [47, 2],
    "ì": [46, 0],
    "ò": [51, 0],
    "ù": [49, 0]
}

mapping['fi'] = {
    "§": [53, 0],
    " ": [44, 0],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    "+": [45, 0],
    "´": [46, 0],
    "q": [20, 0],
    "w": [26, 0],
    "e": [8, 0],
    "r": [21, 0],
    "t": [23, 0],
    "y": [28, 0],
    "u": [24, 0],
    "i": [12, 0],
    "o": [18, 0],
    "p": [19, 0],
    "a": [4, 0],
    "ä": [52, 0],
    "s": [22, 0],
    "d": [7, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "ö": [51, 0],
    "'": [49, 0],
    "<": [100, 0],
    "z": [29, 0],
    "x": [27, 0],
    "c": [6, 0],
    "v": [25, 0],
    "b": [5, 0],
    "n": [17, 0],
    "m": [16, 0],
    ",": [54, 0],
    ".": [55, 0],
    "-": [56, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [32, 2],
    "¤": [33, 2],
    "%": [34, 2],
    "&": [35, 2],
    "/": [36, 2],
    "(": [37, 2],
    ")": [38, 2],
    "=": [39, 2],
    "?": [45, 2],
    "`": [46, 2],
    "Q": [20, 2],
    "W": [26, 2],
    "E": [8, 2],
    "R": [21, 2],
    "T": [23, 2],
    "Y": [28, 2],
    "U": [24, 2],
    "I": [12, 2],
    "O": [18, 2],
    "P": [19, 2],
    "A": [4, 2],
    "^": [48, 2],
    "S": [22, 2],
    "D": [7, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "Ö": [51, 2],
    "Ä": [52, 2],
    "*": [49, 2],
    ">": [100, 2],
    "Z": [29, 2],
    "X": [27, 2],
    "C": [6, 2],
    "V": [25, 2],
    "B": [5, 2],
    "N": [17, 2],
    "M": [16, 2],
    ";": [54, 2],
    ":": [55, 2],
    "_": [56, 2],
    "@": [31, 64],
    "$": [33, 64],
    "€": [8, 64],
    "{": [36, 64],
    "[": [37, 64],
    "]": [38, 64],
    "}": [39, 64],
    "\\": [45, 64],
    "~": [48, 64],
    "|": [100, 64],
    "µ": [16, 64]
}

mapping['fr'] = {
    " ": [44, 0],
    "!": [56, 0],
    "\"": [32, 0],
    "#": [32, 64],
    "$": [48, 0],
    "%": [52, 2],
    "&": [30, 0],
    "'": [33, 0],
    "(": [34, 0],
    ")": [45, 0],
    "*": [49, 0],
    "+": [46, 2],
    ",": [16, 0],
    "-": [35, 0],
    ".": [54, 2],
    "/": [55, 2],
    "0": [39, 2],
    "1": [30, 2],
    "2": [31, 2],
    "3": [32, 2],
    "4": [33, 2],
    "5": [34, 2],
    "6": [35, 2],
    "7": [36, 2],
    "8": [37, 2],
    "9": [38, 2],
    ":": [55, 0],
    ";": [54, 0],
    "<": [100, 0],
    "=": [46, 0],
    ">": [100, 2],
    "?": [16, 2],
    "@": [39, 64],
    "A": [20, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [51, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [4, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [29, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [26, 2],
    "[": [34, 64],
    "\\": [37, 64],
    "]": [45, 64],
    "^": [38, 64],
    "_": [37, 0],
    "`": [36, 64],
    "a": [20, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [51, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [4, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [29, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [26, 0],
    "{": [33, 64],
    "|": [35, 64],
    "}": [46, 64],
    "~": [31, 64],
    "BACKSPACE": [42, 0]
}

mapping['gb'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "\\": [100, 0],
    "$": [33, 2],
    "%": [34, 2],
    "&": [36, 2],
    "'": [52, 0],
    "(": [38, 2],
    ")": [39, 2],
    "*": [37, 2],
    "+": [46, 2],
    ",": [54, 0],
    "-": [45, 0],
    ".": [55, 0],
    "/": [56, 0],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [51, 2],
    ";": [51, 0],
    "<": [54, 2],
    "=": [46, 0],
    ">": [55, 2],
    "?": [56, 2],
    "@": [52, 2],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [47, 0],
    "#": [50, 0],
    "]": [48, 0],
    "^": [35, 2],
    "_": [45, 2],
    "`": [53, 0],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [47, 2],
    "~": [50, 2],
    "}": [48, 2],
    "|": [100, 2],
    "BACKSPACE": [42, 0],
    " ": [44, 0],
    "£": [32, 2],
    "¦": [53, 64],
    "¬": [53, 2],
    "é": [8, 64],
    "í": [12, 64],
    "ó": [18, 64],
    "ú": [24, 64],
    "€": [33, 64]
}

mapping['hr'] = {
    " ": [44, 0],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "č": [51, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "r": [21, 0],
    "s": [22, 0],
    "š": [47, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "z": [28, 0],
    "ž": [49, 0],
    "x": [27, 0],
    "y": [29, 0],
    "q": [20, 0],
    "w": [26, 0],
    "ć": [52, 0],
    "đ": [48, 0],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "Č": [51, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "R": [21, 2],
    "S": [22, 2],
    "Š": [47, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "Z": [28, 2],
    "X": [27, 2],
    "Y": [29, 2],
    "Ž": [49, 2],
    "Q": [20, 2],
    "W": [26, 2],
    "Ć": [52, 2],
    "Đ": [48, 2],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [32, 2],
    "$": [33, 2],
    "%": [34, 2],
    "&": [35, 2],
    "/": [36, 2],
    "(": [37, 2],
    ")": [38, 2],
    "=": [39, 2],
    "?": [45, 2],
    "*": [46, 2],
    "'": [45, 0],
    "+": [46, 0],
    "~": [30, 64],
    "`": [36, 64],
    "\\": [20, 64],
    "|": [26, 64],
    "€": [8, 64],
    "÷": [47, 64],
    "×": [48, 64],
    "[": [9, 64],
    "]": [10, 64],
    "ł": [14, 64],
    "Ł": [15, 64],
    "ß": [52, 64],
    "¤": [49, 64],
    "<": [100, 0],
    ">": [100, 2],
    "@": [25, 64],
    "{": [5, 64],
    "}": [17, 64],
    ".": [55, 0],
    "-": [56, 0],
    ":": [55, 2],
    "_": [56, 2],
    ",": [54, 0],
    ";": [54, 2],
    "§": [16, 64],
    "¸": [46, 64],
    "¨": [45, 64],
    "ˇ": [31, 64],
    "^": [32, 64],
    "˘": [33, 64],
    "°": [34, 64],
    "˛": [35, 64],
    "˙": [37, 64],
    "´": [38, 64],
    "˝": [39, 64],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0]
}

mapping['it'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [52, 64],
    "$": [33, 2],
    "%": [34, 2],
    "&": [35, 2],
    "'": [45, 0],
    "(": [37, 2],
    ")": [38, 2],
    "*": [48, 2],
    "+": [48, 0],
    ",": [54, 0],
    "-": [56, 0],
    ".": [55, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [55, 2],
    ";": [54, 2],
    "<": [100, 0],
    "=": [39, 2],
    ">": [100, 2],
    "?": [45, 2],
    "@": [51, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [47, 64],
    "\\": [53, 0],
    "]": [48, 64],
    "^": [46, 2],
    "_": [56, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [47, 66],
    "|": [53, 2],
    "}": [48, 66],
    "à": [52, 0],
    "è": [47, 0],
    "é": [47, 2],
    "ì": [46, 0],
    "ò": [51, 0],
    "ù": [49, 0]
}

mapping['no'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [32, 2],
    "$": [33, 64],
    "%": [34, 2],
    "&": [35, 2],
    "'": [49, 0],
    "(": [37, 2],
    ")": [38, 2],
    "*": [49, 2],
    "+": [45, 0],
    ",": [54, 0],
    "-": [56, 0],
    ".": [55, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [55, 2],
    ";": [54, 2],
    "<": [100, 0],
    "=": [39, 2],
    ">": [100, 2],
    "?": [45, 2],
    "@": [31, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [37, 64],
    "\\": [46, 0],
    "]": [38, 64],
    "^": [48, 2],
    "_": [56, 2],
    "`": [46, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [36, 64],
    "|": [53, 0],
    "}": [39, 64],
    "~": [48, 64],
    "BACKSPACE": [42, 0],
    " ": [44, 0],
    "£": [32, 64],
    "¤": [33, 2],
    "§": [53, 2],
    "«": [33, 0],
    "µ": [16, 64],
    "½": [53, 0],
    "Å": [47, 2],
    "Æ": [52, 2],
    "Ø": [51, 2],
    "ß": [22, 64],
    "å": [47, 0],
    "æ": [52, 0],
    "ð": [7, 64],
    "ø": [51, 0],
    "þ": [23, 64],
    "€": [8, 64]
}

mapping['pt'] = {
    " ": [44, 0],
    "!": [30, 2],
    "1": [30, 0],
    "\"": [31, 2],
    "2": [31, 0],
    "#": [32, 2],
    "3": [32, 0],
    "$": [33, 2],
    "4": [33, 0],
    "%": [34, 2],
    "5": [34, 0],
    "&": [35, 2],
    "6": [35, 0],
    "/": [36, 2],
    "7": [36, 0],
    "(": [37, 2],
    "8": [37, 0],
    ")": [38, 2],
    "9": [38, 0],
    "=": [39, 2],
    "0": [39, 0],
    "?": [45, 2],
    "'": [45, 0],
    "*": [47, 2],
    "+": [47, 0],
    ",": [54, 0],
    ";": [54, 2],
    "-": [56, 0],
    "_": [56, 2],
    ".": [55, 0],
    ":": [55, 2],
    "<": [100, 0],
    ">": [100, 2],
    "@": [31, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [37, 64],
    "]": [38, 64],
    "^": [50, 2],
    "~": [50, 0],
    "`": [48, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [36, 64],
    "}": [39, 64],
    "|": [53, 2],
    "\\": [53, 0],
    "BACKSPACE": [42, 0],
    "ç": [51, 0],
    "Ç": [51, 2],
    "º": [52, 0],
    "ª": [52, 2],
    "§": [33, 64],
    "£": [32, 64],
    "€": [8, 64],
    "«": [46, 0],
    "»": [46, 2]
}

mapping['ru'] = {
    " ": [44, 0],
    "ё": [53, 0],
    "Ё": [53, 2],
    "1": [30, 0],
    "!": [30, 2],
    "2": [31, 0],
    "\"": [31, 2],
    "3": [32, 0],
    "#": [32, 2],
    "4": [33, 0],
    "$": [33, 2],
    "5": [34, 0],
    "%": [34, 2],
    "6": [35, 0],
    "&": [35, 2],
    "7": [36, 0],
    "'": [36, 2],
    "8": [37, 0],
    "*": [37, 2],
    "9": [38, 0],
    "(": [38, 2],
    "0": [39, 0],
    ")": [39, 2],
    "-": [45, 0],
    "_": [45, 2],
    "Ъ": [46, 0],
    "ъ": [46, 2],
    "Я": [20, 2],
    "я": [20, 0],
    "Ш": [26, 2],
    "ш": [26, 0],
    "Е": [8, 2],
    "е": [8, 0],
    "Р": [9, 2],
    "р": [21, 0],
    "Т": [28, 2],
    "т": [28, 0],
    "Ы": [24, 2],
    "ы": [24, 0],
    "У": [11, 2],
    "у": [11, 0],
    "И": [18, 2],
    "и": [18, 0],
    "О": [19, 2],
    "о": [19, 0],
    "Ю": [47, 2],
    "ю": [47, 0],
    "Щ": [48, 2],
    "щ": [48, 0],
    "А": [4, 2],
    "а": [9, 0],
    "С": [22, 2],
    "с": [22, 0],
    "Д": [7, 2],
    "д": [7, 0],
    "Г": [10, 2],
    "г": [10, 0],
    "Й": [13, 2],
    "й": [13, 0],
    "К": [14, 2],
    "к": [14, 0],
    "Л": [15, 2],
    "л": [15, 0],
    "Ь": [16, 2],
    "ь": [16, 0],
    "Ж": [52, 2],
    "ж": [52, 0],
    "№": [49, 2],
    "~": [49, 0],
    "З": [29, 2],
    "з": [29, 0],
    "Х": [27, 2],
    "х": [27, 0],
    "Ц": [6, 2],
    "ц": [6, 0],
    "В": [25, 2],
    "в": [25, 0],
    "Б": [5, 2],
    "б": [5, 0],
    "Н": [17, 2],
    "н": [17, 0],
    "М": [16, 2],
    "м": [16, 0],
    ",": [54, 2],
    ";": [54, 0],
    ".": [55, 2],
    ":": [55, 0],
    "/": [56, 2],
    "?": [56, 0]
}

mapping['si'] = {
    " ": [44, 0],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "č": [51, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "r": [21, 0],
    "s": [22, 0],
    "š": [47, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "z": [28, 0],
    "ž": [49, 0],
    "x": [27, 0],
    "y": [29, 0],
    "q": [20, 0],
    "w": [26, 0],
    "ć": [52, 0],
    "đ": [48, 0],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "Č": [51, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "R": [21, 2],
    "S": [22, 2],
    "Š": [47, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "Z": [28, 2],
    "X": [27, 2],
    "Y": [29, 2],
    "Ž": [49, 2],
    "Q": [20, 2],
    "W": [26, 2],
    "Ć": [52, 2],
    "Đ": [48, 2],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [32, 2],
    "$": [33, 2],
    "%": [34, 2],
    "&": [35, 2],
    "/": [36, 2],
    "(": [37, 2],
    ")": [38, 2],
    "=": [39, 2],
    "?": [45, 2],
    "*": [46, 2],
    "'": [45, 0],
    "+": [46, 0],
    "~": [30, 64],
    "`": [36, 64],
    "\\": [20, 64],
    "|": [26, 64],
    "€": [8, 64],
    "÷": [47, 64],
    "×": [48, 64],
    "[": [9, 64],
    "]": [10, 64],
    "ł": [14, 64],
    "Ł": [15, 64],
    "ß": [52, 64],
    "¤": [49, 64],
    "<": [100, 0],
    ">": [100, 2],
    "@": [25, 64],
    "{": [5, 64],
    "}": [17, 64],
    ".": [55, 0],
    "-": [56, 0],
    ":": [55, 2],
    "_": [56, 2],
    ",": [54, 0],
    ";": [54, 2],
    "§": [16, 64],
    "¸": [46, 64],
    "¨": [45, 64],
    "ˇ": [31, 64],
    "^": [32, 64],
    "˘": [33, 64],
    "°": [34, 64],
    "˛": [35, 64],
    "˙": [37, 64],
    "´": [38, 64],
    "˝": [39, 64],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0]
}

mapping['sv'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [31, 2],
    "#": [32, 2],
    "$": [33, 64],
    "%": [34, 2],
    "&": [35, 2],
    "'": [49, 0],
    "(": [37, 2],
    ")": [38, 2],
    "*": [49, 2],
    "+": [45, 0],
    ",": [54, 0],
    "-": [56, 0],
    ".": [55, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [55, 2],
    ";": [54, 2],
    "<": [100, 0],
    "=": [39, 2],
    ">": [100, 2],
    "?": [45, 2],
    "@": [31, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [37, 64],
    "\\": [45, 64],
    "]": [38, 64],
    "^": [48, 2],
    "_": [56, 2],
    "`": [46, 2],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [36, 64],
    "|": [100, 64],
    "}": [39, 64],
    "BACKSPACE": [42, 0],
    " ": [44, 0],
    "£": [32, 64],
    "¤": [33, 2],
    "§": [53, 0],
    "«": [33, 0],
    "µ": [16, 64],
    "½": [53, 2],
    "Ä": [52, 2],
    "Å": [47, 2],
    "Ö": [51, 2],
    "ß": [22, 64],
    "ä": [52, 0],
    "å": [47, 0],
    "ð": [7, 64],
    "ö": [51, 0],
    "þ": [23, 64],
    "€": [8, 64]
}

mapping['tr'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [53, 0],
    "#": [32, 64],
    "$": [33, 64],
    "%": [34, 2],
    "&": [36, 2],
    "'": [31, 2],
    "(": [37, 2],
    ")": [38, 2],
    "*": [45, 0],
    "+": [33, 2],
    ",": [49, 0],
    "-": [46, 0],
    ".": [56, 0],
    "/": [36, 2],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [56, 2],
    ";": [49, 2],
    "<": [54, 2],
    "=": [39, 2],
    ">": [55, 2],
    "?": [45, 2],
    "@": [20, 64],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [37, 64],
    "\\": [45, 64],
    "]": [38, 64],
    "^": [32, 2],
    "_": [46, 2],
    "`": [49, 64],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [52, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [36, 64],
    "|": [49, 2],
    "}": [39, 64],
    "~": [48, 64],
    "BACKSPACE": [42, 0]
}

mapping['us'] = {
    " ": [44, 0],
    "!": [30, 2],
    "\"": [52, 2],
    "#": [32, 2],
    "$": [33, 2],
    "%": [34, 2],
    "&": [36, 2],
    "'": [52, 0],
    "(": [38, 2],
    ")": [39, 2],
    "*": [37, 2],
    "+": [46, 2],
    ",": [54, 0],
    "-": [45, 0],
    ".": [55, 0],
    "/": [56, 0],
    "0": [39, 0],
    "1": [30, 0],
    "2": [31, 0],
    "3": [32, 0],
    "4": [33, 0],
    "5": [34, 0],
    "6": [35, 0],
    "7": [36, 0],
    "8": [37, 0],
    "9": [38, 0],
    ":": [51, 2],
    ";": [51, 0],
    "<": [54, 2],
    "=": [46, 0],
    ">": [55, 2],
    "?": [56, 2],
    "@": [31, 2],
    "A": [4, 2],
    "B": [5, 2],
    "C": [6, 2],
    "D": [7, 2],
    "E": [8, 2],
    "F": [9, 2],
    "G": [10, 2],
    "H": [11, 2],
    "I": [12, 2],
    "J": [13, 2],
    "K": [14, 2],
    "L": [15, 2],
    "M": [16, 2],
    "N": [17, 2],
    "O": [18, 2],
    "P": [19, 2],
    "Q": [20, 2],
    "R": [21, 2],
    "S": [22, 2],
    "T": [23, 2],
    "U": [24, 2],
    "V": [25, 2],
    "W": [26, 2],
    "X": [27, 2],
    "Y": [28, 2],
    "Z": [29, 2],
    "[": [47, 0],
    "\\": [49, 0],
    "]": [48, 0],
    "^": [35, 2],
    "_": [45, 2],
    "`": [53, 0],
    "a": [4, 0],
    "b": [5, 0],
    "c": [6, 0],
    "d": [7, 0],
    "e": [8, 0],
    "f": [9, 0],
    "g": [10, 0],
    "h": [11, 0],
    "i": [12, 0],
    "j": [13, 0],
    "k": [14, 0],
    "l": [15, 0],
    "m": [16, 0],
    "n": [17, 0],
    "o": [18, 0],
    "p": [19, 0],
    "q": [20, 0],
    "r": [21, 0],
    "s": [22, 0],
    "t": [23, 0],
    "u": [24, 0],
    "v": [25, 0],
    "w": [26, 0],
    "x": [27, 0],
    "y": [28, 0],
    "z": [29, 0],
    "{": [47, 2],
    "|": [49, 2],
    "}": [48, 2],
    "~": [53, 2],
    "BACKSPACE": [42, 0]
}
