# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit go-module
EGO_PN="github.com/OWASP/Amass"

# use dev-go/get-ego-vendor to generate EGO_SUM
EGO_SUM=(
	"cloud.google.com/go v0.26.0/go.mod"
	"cloud.google.com/go v0.34.0/go.mod"
	"cloud.google.com/go v0.38.0/go.mod"
	"cloud.google.com/go v0.44.1/go.mod"
	"cloud.google.com/go v0.44.2/go.mod"
	"cloud.google.com/go v0.45.1/go.mod"
	"cloud.google.com/go v0.46.3/go.mod"
	"cloud.google.com/go v0.50.0/go.mod"
	"cloud.google.com/go v0.52.0/go.mod"
	"cloud.google.com/go v0.53.0/go.mod"
	"cloud.google.com/go v0.54.0/go.mod"
	"cloud.google.com/go v0.56.0/go.mod"
	"cloud.google.com/go v0.57.0/go.mod"
	"cloud.google.com/go v0.62.0/go.mod"
	"cloud.google.com/go v0.65.0/go.mod"
	"cloud.google.com/go/bigquery v1.0.1/go.mod"
	"cloud.google.com/go/bigquery v1.3.0/go.mod"
	"cloud.google.com/go/bigquery v1.4.0/go.mod"
	"cloud.google.com/go/bigquery v1.5.0/go.mod"
	"cloud.google.com/go/bigquery v1.7.0/go.mod"
	"cloud.google.com/go/bigquery v1.8.0/go.mod"
	"cloud.google.com/go/datastore v1.0.0/go.mod"
	"cloud.google.com/go/datastore v1.1.0/go.mod"
	"cloud.google.com/go/pubsub v1.0.1/go.mod"
	"cloud.google.com/go/pubsub v1.1.0/go.mod"
	"cloud.google.com/go/pubsub v1.2.0/go.mod"
	"cloud.google.com/go/pubsub v1.3.1/go.mod"
	"cloud.google.com/go/storage v1.0.0/go.mod"
	"cloud.google.com/go/storage v1.5.0/go.mod"
	"cloud.google.com/go/storage v1.6.0/go.mod"
	"cloud.google.com/go/storage v1.8.0/go.mod"
	"cloud.google.com/go/storage v1.10.0/go.mod"
	"dmitri.shuralyov.com/gpu/mtl v0.0.0-20190408044501-666a987793e9/go.mod"
	"github.com/AndreasBriese/bbloom v0.0.0-20190825152654-46b345b51c96"
	"github.com/AndreasBriese/bbloom v0.0.0-20190825152654-46b345b51c96/go.mod"
	"github.com/BurntSushi/toml v0.3.1/go.mod"
	"github.com/BurntSushi/xgb v0.0.0-20160522181843-27f122750802/go.mod"
	"github.com/DataDog/datadog-go v3.2.0+incompatible/go.mod"
	"github.com/HdrHistogram/hdrhistogram-go v1.1.0/go.mod"
	"github.com/HdrHistogram/hdrhistogram-go v1.1.2/go.mod"
	"github.com/Knetic/govaluate v3.0.1-0.20171022003610-9aa49832a739+incompatible/go.mod"
	"github.com/OneOfOne/xxhash v1.2.2/go.mod"
	"github.com/PuerkitoBio/goquery v1.8.0/go.mod"
	"github.com/PuerkitoBio/goquery v1.8.1"
	"github.com/PuerkitoBio/goquery v1.8.1/go.mod"
	"github.com/Shopify/sarama v1.19.0/go.mod"
	"github.com/Shopify/toxiproxy v2.1.4+incompatible/go.mod"
	"github.com/VividCortex/gohistogram v1.0.0"
	"github.com/VividCortex/gohistogram v1.0.0/go.mod"
	"github.com/afex/hystrix-go v0.0.0-20180502004556-fa1af6a1f4f5/go.mod"
	"github.com/ajstarks/svgo v0.0.0-20180226025133-644b8db467af/go.mod"
	"github.com/alecthomas/template v0.0.0-20160405071501-a0175ee3bccc/go.mod"
	"github.com/alecthomas/template v0.0.0-20190718012654-fb15b899a751/go.mod"
	"github.com/alecthomas/units v0.0.0-20151022065526-2efee857e7cf/go.mod"
	"github.com/alecthomas/units v0.0.0-20190717042225-c3de453c63f4/go.mod"
	"github.com/alecthomas/units v0.0.0-20190924025748-f65c72e2690d/go.mod"
	"github.com/andybalholm/cascadia v1.3.1/go.mod"
	"github.com/andybalholm/cascadia v1.3.2"
	"github.com/andybalholm/cascadia v1.3.2/go.mod"
	"github.com/antihax/optional v1.0.0/go.mod"
	"github.com/armon/circbuf v0.0.0-20150827004946-bbbad097214e/go.mod"
	"github.com/armon/consul-api v0.0.0-20180202201655-eb2c6b5be1b6/go.mod"
	"github.com/armon/go-metrics v0.0.0-20180917152333-f0300d1749da/go.mod"
	"github.com/armon/go-metrics v0.3.9/go.mod"
	"github.com/armon/go-radix v0.0.0-20180808171621-7fddfc383310/go.mod"
	"github.com/armon/go-radix v1.0.0/go.mod"
	"github.com/aws/aws-sdk-go v1.40.45/go.mod"
	"github.com/aws/aws-sdk-go-v2 v1.9.1/go.mod"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatch v1.8.1/go.mod"
	"github.com/aws/smithy-go v1.8.0/go.mod"
	"github.com/benbjohnson/clock v1.1.0/go.mod"
	"github.com/benbjohnson/clock v1.3.5"
	"github.com/benbjohnson/clock v1.3.5/go.mod"
	"github.com/beorn7/perks v0.0.0-20180321164747-3a771d992973/go.mod"
	"github.com/beorn7/perks v1.0.0/go.mod"
	"github.com/beorn7/perks v1.0.1"
	"github.com/beorn7/perks v1.0.1/go.mod"
	"github.com/bgentry/speakeasy v0.1.0/go.mod"
	"github.com/caffix/netmap v0.2.5"
	"github.com/caffix/netmap v0.2.5/go.mod"
	"github.com/caffix/pipeline v0.2.2"
	"github.com/caffix/pipeline v0.2.2/go.mod"
	"github.com/caffix/queue v0.1.4"
	"github.com/caffix/queue v0.1.4/go.mod"
	"github.com/caffix/service v0.3.0"
	"github.com/caffix/service v0.3.0/go.mod"
	"github.com/caffix/stringset v0.1.1"
	"github.com/caffix/stringset v0.1.1/go.mod"
	"github.com/casbin/casbin/v2 v2.37.0/go.mod"
	"github.com/cenkalti/backoff/v4 v4.1.1/go.mod"
	"github.com/census-instrumentation/opencensus-proto v0.2.1/go.mod"
	"github.com/cespare/xxhash v1.1.0/go.mod"
	"github.com/cespare/xxhash/v2 v2.1.1/go.mod"
	"github.com/cespare/xxhash/v2 v2.1.2/go.mod"
	"github.com/cespare/xxhash/v2 v2.2.0"
	"github.com/cespare/xxhash/v2 v2.2.0/go.mod"
	"github.com/chromedp/cdproto v0.0.0-20220321060548-7bc2623472b3/go.mod"
	"github.com/chromedp/cdproto v0.0.0-20220428002153-285dfb42699c/go.mod"
	"github.com/chromedp/cdproto v0.0.0-20230802225258-3cf4e6d46a89/go.mod"
	"github.com/chromedp/cdproto v0.0.0-20230909221021-38a8736298fe"
	"github.com/chromedp/cdproto v0.0.0-20230909221021-38a8736298fe/go.mod"
	"github.com/chromedp/chromedp v0.8.0/go.mod"
	"github.com/chromedp/chromedp v0.9.2"
	"github.com/chromedp/chromedp v0.9.2/go.mod"
	"github.com/chromedp/sysutil v1.0.0"
	"github.com/chromedp/sysutil v1.0.0/go.mod"
	"github.com/chzyer/logex v1.1.10/go.mod"
	"github.com/chzyer/readline v0.0.0-20180603132655-2972be24d48e/go.mod"
	"github.com/chzyer/test v0.0.0-20180213035817-a1ea475d72b1/go.mod"
	"github.com/circonus-labs/circonus-gometrics v2.3.1+incompatible/go.mod"
	"github.com/circonus-labs/circonusllhist v0.1.3/go.mod"
	"github.com/cjoudrey/gluaurl v0.0.0-20161028222611-31cbb9bef199"
	"github.com/cjoudrey/gluaurl v0.0.0-20161028222611-31cbb9bef199/go.mod"
	"github.com/clbanning/mxj v1.8.4/go.mod"
	"github.com/client9/misspell v0.3.4/go.mod"
	"github.com/cncf/udpa/go v0.0.0-20191209042840-269d4d468f6f/go.mod"
	"github.com/cncf/udpa/go v0.0.0-20201120205902-5459f2c99403/go.mod"
	"github.com/cncf/xds/go v0.0.0-20210312221358-fbca930ec8ed/go.mod"
	"github.com/coreos/etcd v3.3.10+incompatible/go.mod"
	"github.com/coreos/go-etcd v2.0.0+incompatible/go.mod"
	"github.com/coreos/go-semver v0.2.0/go.mod"
	"github.com/coreos/go-semver v0.3.0/go.mod"
	"github.com/coreos/go-systemd/v22 v22.3.2/go.mod"
	"github.com/cpuguy83/go-md2man v1.0.10/go.mod"
	"github.com/creack/pty v1.1.9/go.mod"
	"github.com/d4l3k/messagediff v1.2.1"
	"github.com/davecgh/go-spew v1.1.0/go.mod"
	"github.com/davecgh/go-spew v1.1.1"
	"github.com/davecgh/go-spew v1.1.1/go.mod"
	"github.com/dgraph-io/badger v1.6.2"
	"github.com/dgraph-io/badger v1.6.2/go.mod"
	"github.com/dgraph-io/ristretto v0.0.2/go.mod"
	"github.com/dgraph-io/ristretto v0.1.1"
	"github.com/dgraph-io/ristretto v0.1.1/go.mod"
	"github.com/dgryski/go-farm v0.0.0-20190423205320-6a90982ecee2"
	"github.com/dgryski/go-farm v0.0.0-20190423205320-6a90982ecee2/go.mod"
	"github.com/dustin/go-humanize v1.0.0/go.mod"
	"github.com/dustin/go-humanize v1.0.1"
	"github.com/dustin/go-humanize v1.0.1/go.mod"
	"github.com/eapache/go-resiliency v1.1.0/go.mod"
	"github.com/eapache/go-xerial-snappy v0.0.0-20180814174437-776d5712da21/go.mod"
	"github.com/eapache/queue v1.1.0/go.mod"
	"github.com/edsrzf/mmap-go v1.0.0/go.mod"
	"github.com/elazarl/goproxy v0.0.0-20210801061803-8e322dfb79c4"
	"github.com/elazarl/goproxy v0.0.0-20210801061803-8e322dfb79c4/go.mod"
	"github.com/elazarl/goproxy/ext v0.0.0-20190711103511-473e67f1d7d2/go.mod"
	"github.com/envoyproxy/go-control-plane v0.9.0/go.mod"
	"github.com/envoyproxy/go-control-plane v0.9.1-0.20191026205805-5f8ba28d4473/go.mod"
	"github.com/envoyproxy/go-control-plane v0.9.4/go.mod"
	"github.com/envoyproxy/go-control-plane v0.9.9-0.20201210154907-fd9021fe5dad/go.mod"
	"github.com/envoyproxy/go-control-plane v0.9.9-0.20210217033140-668b12f5399d/go.mod"
	"github.com/envoyproxy/go-control-plane v0.9.9-0.20210512163311-63b5d3c536b0/go.mod"
	"github.com/envoyproxy/protoc-gen-validate v0.1.0/go.mod"
	"github.com/fatih/color v1.7.0/go.mod"
	"github.com/fatih/color v1.9.0/go.mod"
	"github.com/fatih/color v1.12.0/go.mod"
	"github.com/fatih/color v1.15.0"
	"github.com/fatih/color v1.15.0/go.mod"
	"github.com/fogleman/gg v1.2.1-0.20190220221249-0403632d5b90/go.mod"
	"github.com/fortytw2/leaktest v1.3.0"
	"github.com/fortytw2/leaktest v1.3.0/go.mod"
	"github.com/franela/goblin v0.0.0-20210519012713-85d372ac71e2/go.mod"
	"github.com/franela/goreq v0.0.0-20171204163338-bcd34c9993f8/go.mod"
	"github.com/fsnotify/fsnotify v1.4.7/go.mod"
	"github.com/fsnotify/fsnotify v1.4.9/go.mod"
	"github.com/geziyor/geziyor v0.0.0-20230315135110-a242b58aaa65"
	"github.com/geziyor/geziyor v0.0.0-20230315135110-a242b58aaa65/go.mod"
	"github.com/ghodss/yaml v1.0.0/go.mod"
	"github.com/glebarez/go-sqlite v1.21.2"
	"github.com/glebarez/go-sqlite v1.21.2/go.mod"
	"github.com/glebarez/sqlite v1.9.0"
	"github.com/glebarez/sqlite v1.9.0/go.mod"
	"github.com/go-gl/glfw v0.0.0-20190409004039-e6da0acd62b1/go.mod"
	"github.com/go-gl/glfw/v3.3/glfw v0.0.0-20191125211704-12ad95a8df72/go.mod"
	"github.com/go-gl/glfw/v3.3/glfw v0.0.0-20200222043503-6f7a984d4dc4/go.mod"
	"github.com/go-gorp/gorp/v3 v3.1.0"
	"github.com/go-gorp/gorp/v3 v3.1.0/go.mod"
	"github.com/go-kit/kit v0.8.0/go.mod"
	"github.com/go-kit/kit v0.9.0/go.mod"
	"github.com/go-kit/kit v0.12.0/go.mod"
	"github.com/go-kit/kit v0.13.0"
	"github.com/go-kit/kit v0.13.0/go.mod"
	"github.com/go-kit/log v0.1.0/go.mod"
	"github.com/go-kit/log v0.2.0/go.mod"
	"github.com/go-logfmt/logfmt v0.3.0/go.mod"
	"github.com/go-logfmt/logfmt v0.4.0/go.mod"
	"github.com/go-logfmt/logfmt v0.5.0/go.mod"
	"github.com/go-logfmt/logfmt v0.5.1/go.mod"
	"github.com/go-sql-driver/mysql v1.7.0/go.mod"
	"github.com/go-sql-driver/mysql v1.7.1"
	"github.com/go-sql-driver/mysql v1.7.1/go.mod"
	"github.com/go-stack/stack v1.8.0/go.mod"
	"github.com/go-task/slim-sprig v0.0.0-20210107165309-348f09dbbbc0/go.mod"
	"github.com/go-zookeeper/zk v1.0.2/go.mod"
	"github.com/gobuffalo/logger v1.0.7"
	"github.com/gobuffalo/logger v1.0.7/go.mod"
	"github.com/gobuffalo/packd v1.0.2"
	"github.com/gobuffalo/packd v1.0.2/go.mod"
	"github.com/gobuffalo/packr/v2 v2.8.3"
	"github.com/gobwas/httphead v0.1.0"
	"github.com/gobwas/httphead v0.1.0/go.mod"
	"github.com/gobwas/pool v0.2.1"
	"github.com/gobwas/pool v0.2.1/go.mod"
	"github.com/gobwas/ws v1.1.0/go.mod"
	"github.com/gobwas/ws v1.2.1/go.mod"
	"github.com/gobwas/ws v1.3.0"
	"github.com/gobwas/ws v1.3.0/go.mod"
	"github.com/godbus/dbus/v5 v5.0.4/go.mod"
	"github.com/gogo/protobuf v1.1.1/go.mod"
	"github.com/gogo/protobuf v1.3.2/go.mod"
	"github.com/golang-jwt/jwt/v4 v4.0.0/go.mod"
	"github.com/golang-sql/civil v0.0.0-20220223132316-b832511892a9"
	"github.com/golang-sql/sqlexp v0.1.0"
	"github.com/golang/freetype v0.0.0-20170609003504-e2365dfdc4a0/go.mod"
	"github.com/golang/glog v0.0.0-20160126235308-23def4e6c14b/go.mod"
	"github.com/golang/glog v1.1.2"
	"github.com/golang/glog v1.1.2/go.mod"
	"github.com/golang/groupcache v0.0.0-20190702054246-869f871628b6/go.mod"
	"github.com/golang/groupcache v0.0.0-20191227052852-215e87163ea7/go.mod"
	"github.com/golang/groupcache v0.0.0-20200121045136-8c9f03a8e57e/go.mod"
	"github.com/golang/groupcache v0.0.0-20210331224755-41bb18bfe9da/go.mod"
	"github.com/golang/mock v1.1.1/go.mod"
	"github.com/golang/mock v1.2.0/go.mod"
	"github.com/golang/mock v1.3.1/go.mod"
	"github.com/golang/mock v1.4.0/go.mod"
	"github.com/golang/mock v1.4.1/go.mod"
	"github.com/golang/mock v1.4.3/go.mod"
	"github.com/golang/mock v1.4.4/go.mod"
	"github.com/golang/protobuf v1.2.0/go.mod"
	"github.com/golang/protobuf v1.3.1/go.mod"
	"github.com/golang/protobuf v1.3.2/go.mod"
	"github.com/golang/protobuf v1.3.3/go.mod"
	"github.com/golang/protobuf v1.3.4/go.mod"
	"github.com/golang/protobuf v1.3.5/go.mod"
	"github.com/golang/protobuf v1.4.0-rc.1/go.mod"
	"github.com/golang/protobuf v1.4.0-rc.1.0.20200221234624-67d41d38c208/go.mod"
	"github.com/golang/protobuf v1.4.0-rc.2/go.mod"
	"github.com/golang/protobuf v1.4.0-rc.4.0.20200313231945-b860323f09d0/go.mod"
	"github.com/golang/protobuf v1.4.0/go.mod"
	"github.com/golang/protobuf v1.4.1/go.mod"
	"github.com/golang/protobuf v1.4.2/go.mod"
	"github.com/golang/protobuf v1.4.3/go.mod"
	"github.com/golang/protobuf v1.5.0/go.mod"
	"github.com/golang/protobuf v1.5.2/go.mod"
	"github.com/golang/protobuf v1.5.3"
	"github.com/golang/protobuf v1.5.3/go.mod"
	"github.com/golang/snappy v0.0.0-20180518054509-2e65f85255db/go.mod"
	"github.com/golang/snappy v0.0.3/go.mod"
	"github.com/google/btree v0.0.0-20180813153112-4030bb1f1f0c/go.mod"
	"github.com/google/btree v1.0.0"
	"github.com/google/btree v1.0.0/go.mod"
	"github.com/google/go-cmp v0.2.0/go.mod"
	"github.com/google/go-cmp v0.3.0/go.mod"
	"github.com/google/go-cmp v0.3.1/go.mod"
	"github.com/google/go-cmp v0.4.0/go.mod"
	"github.com/google/go-cmp v0.4.1/go.mod"
	"github.com/google/go-cmp v0.5.0/go.mod"
	"github.com/google/go-cmp v0.5.1/go.mod"
	"github.com/google/go-cmp v0.5.3/go.mod"
	"github.com/google/go-cmp v0.5.4/go.mod"
	"github.com/google/go-cmp v0.5.5/go.mod"
	"github.com/google/go-cmp v0.5.6/go.mod"
	"github.com/google/go-cmp v0.5.9"
	"github.com/google/gofuzz v1.0.0/go.mod"
	"github.com/google/martian v2.1.0+incompatible/go.mod"
	"github.com/google/martian/v3 v3.0.0/go.mod"
	"github.com/google/pprof v0.0.0-20181206194817-3ea8567a2e57/go.mod"
	"github.com/google/pprof v0.0.0-20190515194954-54271f7e092f/go.mod"
	"github.com/google/pprof v0.0.0-20191218002539-d4f498aebedc/go.mod"
	"github.com/google/pprof v0.0.0-20200212024743-f11f1df84d12/go.mod"
	"github.com/google/pprof v0.0.0-20200229191704-1ebb73c60ed3/go.mod"
	"github.com/google/pprof v0.0.0-20200430221834-fc25d7d30c6d/go.mod"
	"github.com/google/pprof v0.0.0-20200708004538-1a94d8640e99/go.mod"
	"github.com/google/pprof v0.0.0-20221118152302-e6195bd50e26"
	"github.com/google/renameio v0.1.0/go.mod"
	"github.com/google/uuid v1.1.2/go.mod"
	"github.com/google/uuid v1.3.1"
	"github.com/google/uuid v1.3.1/go.mod"
	"github.com/googleapis/gax-go/v2 v2.0.4/go.mod"
	"github.com/googleapis/gax-go/v2 v2.0.5/go.mod"
	"github.com/gopherjs/gopherjs v0.0.0-20181017120253-0766667cb4d1/go.mod"
	"github.com/gorilla/context v1.1.1/go.mod"
	"github.com/gorilla/mux v1.6.2/go.mod"
	"github.com/grpc-ecosystem/go-grpc-prometheus v1.2.0/go.mod"
	"github.com/grpc-ecosystem/grpc-gateway v1.16.0/go.mod"
	"github.com/hashicorp/consul/api v1.10.1/go.mod"
	"github.com/hashicorp/consul/sdk v0.8.0/go.mod"
	"github.com/hashicorp/errwrap v1.0.0/go.mod"
	"github.com/hashicorp/errwrap v1.1.0"
	"github.com/hashicorp/errwrap v1.1.0/go.mod"
	"github.com/hashicorp/go-cleanhttp v0.5.0/go.mod"
	"github.com/hashicorp/go-cleanhttp v0.5.1/go.mod"
	"github.com/hashicorp/go-cleanhttp v0.5.2/go.mod"
	"github.com/hashicorp/go-hclog v0.12.0/go.mod"
	"github.com/hashicorp/go-hclog v0.16.2/go.mod"
	"github.com/hashicorp/go-immutable-radix v1.0.0/go.mod"
	"github.com/hashicorp/go-immutable-radix v1.3.1/go.mod"
	"github.com/hashicorp/go-msgpack v0.5.3/go.mod"
	"github.com/hashicorp/go-multierror v1.0.0/go.mod"
	"github.com/hashicorp/go-multierror v1.1.0/go.mod"
	"github.com/hashicorp/go-multierror v1.1.1"
	"github.com/hashicorp/go-multierror v1.1.1/go.mod"
	"github.com/hashicorp/go-retryablehttp v0.5.3/go.mod"
	"github.com/hashicorp/go-rootcerts v1.0.2/go.mod"
	"github.com/hashicorp/go-sockaddr v1.0.0/go.mod"
	"github.com/hashicorp/go-syslog v1.0.0/go.mod"
	"github.com/hashicorp/go-uuid v1.0.0/go.mod"
	"github.com/hashicorp/go-uuid v1.0.1/go.mod"
	"github.com/hashicorp/golang-lru v0.5.0/go.mod"
	"github.com/hashicorp/golang-lru v0.5.1/go.mod"
	"github.com/hashicorp/golang-lru v0.5.4/go.mod"
	"github.com/hashicorp/hcl v1.0.0/go.mod"
	"github.com/hashicorp/logutils v1.0.0/go.mod"
	"github.com/hashicorp/mdns v1.0.1/go.mod"
	"github.com/hashicorp/memberlist v0.2.2/go.mod"
	"github.com/hashicorp/serf v0.9.5/go.mod"
	"github.com/hpcloud/tail v1.0.0/go.mod"
	"github.com/hudl/fargo v1.4.0/go.mod"
	"github.com/ianlancetaylor/demangle v0.0.0-20181102032728-5e5cf60278f6/go.mod"
	"github.com/inconshreveable/mousetrap v1.0.0/go.mod"
	"github.com/influxdata/influxdb1-client v0.0.0-20200827194710-b269163b24ab/go.mod"
	"github.com/jackc/pgpassfile v1.0.0"
	"github.com/jackc/pgpassfile v1.0.0/go.mod"
	"github.com/jackc/pgservicefile v0.0.0-20221227161230-091c0ba34f0a"
	"github.com/jackc/pgservicefile v0.0.0-20221227161230-091c0ba34f0a/go.mod"
	"github.com/jackc/pgx/v5 v5.4.3"
	"github.com/jackc/pgx/v5 v5.4.3/go.mod"
	"github.com/jinzhu/inflection v1.0.0"
	"github.com/jinzhu/inflection v1.0.0/go.mod"
	"github.com/jinzhu/now v1.1.5"
	"github.com/jinzhu/now v1.1.5/go.mod"
	"github.com/jmespath/go-jmespath v0.4.0/go.mod"
	"github.com/jmespath/go-jmespath/internal/testify v1.5.1/go.mod"
	"github.com/josharian/intern v1.0.0"
	"github.com/josharian/intern v1.0.0/go.mod"
	"github.com/jpillora/backoff v1.0.0/go.mod"
	"github.com/json-iterator/go v1.1.6/go.mod"
	"github.com/json-iterator/go v1.1.9/go.mod"
	"github.com/json-iterator/go v1.1.10/go.mod"
	"github.com/json-iterator/go v1.1.11/go.mod"
	"github.com/json-iterator/go v1.1.12/go.mod"
	"github.com/jstemmer/go-junit-report v0.0.0-20190106144839-af01ea7f8024/go.mod"
	"github.com/jstemmer/go-junit-report v0.9.1/go.mod"
	"github.com/jtolds/gls v4.20.0+incompatible/go.mod"
	"github.com/julienschmidt/httprouter v1.2.0/go.mod"
	"github.com/julienschmidt/httprouter v1.3.0/go.mod"
	"github.com/jung-kurt/gofpdf v1.0.3-0.20190309125859-24315acbbda5/go.mod"
	"github.com/karrick/godirwalk v1.17.0"
	"github.com/karrick/godirwalk v1.17.0/go.mod"
	"github.com/kisielk/errcheck v1.5.0/go.mod"
	"github.com/kisielk/gotool v1.0.0/go.mod"
	"github.com/klauspost/compress v1.13.4/go.mod"
	"github.com/klauspost/compress v1.13.6/go.mod"
	"github.com/konsorten/go-windows-terminal-sequences v1.0.1/go.mod"
	"github.com/konsorten/go-windows-terminal-sequences v1.0.3/go.mod"
	"github.com/kr/logfmt v0.0.0-20140226030751-b84e30acd515/go.mod"
	"github.com/kr/pretty v0.1.0/go.mod"
	"github.com/kr/pretty v0.2.0/go.mod"
	"github.com/kr/pretty v0.3.1"
	"github.com/kr/pty v1.1.1/go.mod"
	"github.com/kr/text v0.1.0/go.mod"
	"github.com/kr/text v0.2.0"
	"github.com/kr/text v0.2.0/go.mod"
	"github.com/ledongthuc/pdf v0.0.0-20220302134840-0c2507a12d80"
	"github.com/ledongthuc/pdf v0.0.0-20220302134840-0c2507a12d80/go.mod"
	"github.com/lib/pq v1.10.7"
	"github.com/magiconair/properties v1.8.0/go.mod"
	"github.com/mailru/easyjson v0.7.7"
	"github.com/mailru/easyjson v0.7.7/go.mod"
	"github.com/markbates/errx v1.1.0"
	"github.com/markbates/oncer v1.0.0"
	"github.com/markbates/safe v1.0.1"
	"github.com/mattn/go-colorable v0.0.9/go.mod"
	"github.com/mattn/go-colorable v0.1.4/go.mod"
	"github.com/mattn/go-colorable v0.1.6/go.mod"
	"github.com/mattn/go-colorable v0.1.8/go.mod"
	"github.com/mattn/go-colorable v0.1.13"
	"github.com/mattn/go-colorable v0.1.13/go.mod"
	"github.com/mattn/go-isatty v0.0.3/go.mod"
	"github.com/mattn/go-isatty v0.0.8/go.mod"
	"github.com/mattn/go-isatty v0.0.10/go.mod"
	"github.com/mattn/go-isatty v0.0.11/go.mod"
	"github.com/mattn/go-isatty v0.0.12/go.mod"
	"github.com/mattn/go-isatty v0.0.14/go.mod"
	"github.com/mattn/go-isatty v0.0.16/go.mod"
	"github.com/mattn/go-isatty v0.0.19"
	"github.com/mattn/go-isatty v0.0.19/go.mod"
	"github.com/mattn/go-sqlite3 v1.14.17"
	"github.com/matttproud/golang_protobuf_extensions v1.0.1/go.mod"
	"github.com/matttproud/golang_protobuf_extensions v1.0.4"
	"github.com/matttproud/golang_protobuf_extensions v1.0.4/go.mod"
	"github.com/microsoft/go-mssqldb v0.17.0"
	"github.com/miekg/dns v1.0.14/go.mod"
	"github.com/miekg/dns v1.1.26/go.mod"
	"github.com/miekg/dns v1.1.43/go.mod"
	"github.com/miekg/dns v1.1.55"
	"github.com/miekg/dns v1.1.55/go.mod"
	"github.com/minio/highwayhash v1.0.1/go.mod"
	"github.com/minio/highwayhash v1.0.2/go.mod"
	"github.com/mitchellh/cli v1.1.0/go.mod"
	"github.com/mitchellh/go-homedir v1.1.0/go.mod"
	"github.com/mitchellh/go-testing-interface v1.0.0/go.mod"
	"github.com/mitchellh/mapstructure v0.0.0-20160808181253-ca63d7c062ee/go.mod"
	"github.com/mitchellh/mapstructure v1.1.2/go.mod"
	"github.com/mitchellh/mapstructure v1.4.2/go.mod"
	"github.com/modern-go/concurrent v0.0.0-20180228061459-e0a39a4cb421/go.mod"
	"github.com/modern-go/concurrent v0.0.0-20180306012644-bacd9c7ef1dd/go.mod"
	"github.com/modern-go/reflect2 v0.0.0-20180701023420-4b7aa43c6742/go.mod"
	"github.com/modern-go/reflect2 v1.0.1/go.mod"
	"github.com/modern-go/reflect2 v1.0.2/go.mod"
	"github.com/mwitkow/go-conntrack v0.0.0-20161129095857-cc309e4a2223/go.mod"
	"github.com/mwitkow/go-conntrack v0.0.0-20190716064945-2f068394615f/go.mod"
	"github.com/nats-io/jwt v1.2.2/go.mod"
	"github.com/nats-io/jwt/v2 v2.0.3/go.mod"
	"github.com/nats-io/nats-server/v2 v2.5.0/go.mod"
	"github.com/nats-io/nats.go v1.12.1/go.mod"
	"github.com/nats-io/nkeys v0.2.0/go.mod"
	"github.com/nats-io/nkeys v0.3.0/go.mod"
	"github.com/nats-io/nuid v1.0.1/go.mod"
	"github.com/niemeyer/pretty v0.0.0-20200227124842-a10e7caefd8e/go.mod"
	"github.com/nxadm/tail v1.4.4/go.mod"
	"github.com/nxadm/tail v1.4.8/go.mod"
	"github.com/onsi/ginkgo v1.6.0/go.mod"
	"github.com/onsi/ginkgo v1.7.0/go.mod"
	"github.com/onsi/ginkgo v1.12.1/go.mod"
	"github.com/onsi/ginkgo v1.16.2/go.mod"
	"github.com/onsi/gomega v1.4.3/go.mod"
	"github.com/onsi/gomega v1.7.1/go.mod"
	"github.com/onsi/gomega v1.10.1/go.mod"
	"github.com/onsi/gomega v1.13.0/go.mod"
	"github.com/op/go-logging v0.0.0-20160315200505-970db520ece7/go.mod"
	"github.com/opentracing/opentracing-go v1.2.0/go.mod"
	"github.com/openzipkin/zipkin-go v0.2.5/go.mod"
	"github.com/orisano/pixelmatch v0.0.0-20210112091706-4fa4c7ba91d5/go.mod"
	"github.com/orisano/pixelmatch v0.0.0-20220722002657-fb0b55479cde"
	"github.com/orisano/pixelmatch v0.0.0-20220722002657-fb0b55479cde/go.mod"
	"github.com/owasp-amass/asset-db v0.3.3"
	"github.com/owasp-amass/asset-db v0.3.3/go.mod"
	"github.com/owasp-amass/config v0.1.4"
	"github.com/owasp-amass/config v0.1.4/go.mod"
	"github.com/owasp-amass/open-asset-model v0.2.0"
	"github.com/owasp-amass/open-asset-model v0.2.0/go.mod"
	"github.com/owasp-amass/resolve v0.6.21"
	"github.com/owasp-amass/resolve v0.6.21/go.mod"
	"github.com/pascaldekloe/goe v0.0.0-20180627143212-57f6aae5913c/go.mod"
	"github.com/pascaldekloe/goe v0.1.0/go.mod"
	"github.com/pelletier/go-toml v1.2.0/go.mod"
	"github.com/performancecopilot/speed/v4 v4.0.0/go.mod"
	"github.com/peterbourgon/diskv v2.0.1+incompatible"
	"github.com/peterbourgon/diskv v2.0.1+incompatible/go.mod"
	"github.com/pierrec/lz4 v1.0.2-0.20190131084431-473cd7ce01a1/go.mod"
	"github.com/pkg/errors v0.8.0/go.mod"
	"github.com/pkg/errors v0.8.1/go.mod"
	"github.com/pkg/errors v0.9.1"
	"github.com/pkg/errors v0.9.1/go.mod"
	"github.com/pkg/profile v1.2.1/go.mod"
	"github.com/pmezard/go-difflib v1.0.0"
	"github.com/pmezard/go-difflib v1.0.0/go.mod"
	"github.com/posener/complete v1.1.1/go.mod"
	"github.com/posener/complete v1.2.3/go.mod"
	"github.com/poy/onpar v1.1.2"
	"github.com/prometheus/client_golang v0.9.1/go.mod"
	"github.com/prometheus/client_golang v1.0.0/go.mod"
	"github.com/prometheus/client_golang v1.4.0/go.mod"
	"github.com/prometheus/client_golang v1.7.1/go.mod"
	"github.com/prometheus/client_golang v1.11.0/go.mod"
	"github.com/prometheus/client_golang v1.12.1/go.mod"
	"github.com/prometheus/client_golang v1.16.0"
	"github.com/prometheus/client_golang v1.16.0/go.mod"
	"github.com/prometheus/client_model v0.0.0-20180712105110-5c3871d89910/go.mod"
	"github.com/prometheus/client_model v0.0.0-20190129233127-fd36f4220a90/go.mod"
	"github.com/prometheus/client_model v0.0.0-20190812154241-14fe0d1b01d4/go.mod"
	"github.com/prometheus/client_model v0.2.0/go.mod"
	"github.com/prometheus/client_model v0.4.0"
	"github.com/prometheus/client_model v0.4.0/go.mod"
	"github.com/prometheus/common v0.4.1/go.mod"
	"github.com/prometheus/common v0.9.1/go.mod"
	"github.com/prometheus/common v0.10.0/go.mod"
	"github.com/prometheus/common v0.26.0/go.mod"
	"github.com/prometheus/common v0.30.0/go.mod"
	"github.com/prometheus/common v0.32.1/go.mod"
	"github.com/prometheus/common v0.34.0/go.mod"
	"github.com/prometheus/common v0.44.0"
	"github.com/prometheus/common v0.44.0/go.mod"
	"github.com/prometheus/procfs v0.0.0-20181005140218-185b4288413d/go.mod"
	"github.com/prometheus/procfs v0.0.2/go.mod"
	"github.com/prometheus/procfs v0.0.8/go.mod"
	"github.com/prometheus/procfs v0.1.3/go.mod"
	"github.com/prometheus/procfs v0.6.0/go.mod"
	"github.com/prometheus/procfs v0.7.3/go.mod"
	"github.com/prometheus/procfs v0.11.1"
	"github.com/prometheus/procfs v0.11.1/go.mod"
	"github.com/rcrowley/go-metrics v0.0.0-20181016184325-3113b8401b8a/go.mod"
	"github.com/remyoudompheng/bigfft v0.0.0-20230129092748-24d4a6f8daec"
	"github.com/remyoudompheng/bigfft v0.0.0-20230129092748-24d4a6f8daec/go.mod"
	"github.com/rogpeppe/fastuuid v1.2.0/go.mod"
	"github.com/rogpeppe/go-charset v0.0.0-20180617210344-2471d30d28b4/go.mod"
	"github.com/rogpeppe/go-internal v1.3.0/go.mod"
	"github.com/rogpeppe/go-internal v1.10.0"
	"github.com/rubenv/sql-migrate v1.5.2"
	"github.com/rubenv/sql-migrate v1.5.2/go.mod"
	"github.com/russross/blackfriday v1.5.2/go.mod"
	"github.com/ryanuber/columnize v0.0.0-20160712163229-9b3edd62028f/go.mod"
	"github.com/sean-/seed v0.0.0-20170313163322-e2103e2c3529/go.mod"
	"github.com/sirupsen/logrus v1.2.0/go.mod"
	"github.com/sirupsen/logrus v1.4.2/go.mod"
	"github.com/sirupsen/logrus v1.6.0/go.mod"
	"github.com/sirupsen/logrus v1.8.1/go.mod"
	"github.com/sirupsen/logrus v1.9.0"
	"github.com/sirupsen/logrus v1.9.0/go.mod"
	"github.com/smartystreets/assertions v0.0.0-20180927180507-b2de0cb4f26d/go.mod"
	"github.com/smartystreets/goconvey v1.6.4/go.mod"
	"github.com/sony/gobreaker v0.4.1/go.mod"
	"github.com/spaolacci/murmur3 v0.0.0-20180118202830-f09979ecbc72/go.mod"
	"github.com/spaolacci/murmur3 v1.1.0/go.mod"
	"github.com/spf13/afero v1.1.2/go.mod"
	"github.com/spf13/cast v1.3.0/go.mod"
	"github.com/spf13/cobra v0.0.5/go.mod"
	"github.com/spf13/jwalterweatherman v1.0.0/go.mod"
	"github.com/spf13/pflag v1.0.3/go.mod"
	"github.com/spf13/viper v1.3.2/go.mod"
	"github.com/streadway/amqp v0.0.0-20190404075320-75d898a42a94/go.mod"
	"github.com/streadway/amqp v1.0.0/go.mod"
	"github.com/streadway/handy v0.0.0-20200128134331-0f66f006fb2e/go.mod"
	"github.com/stretchr/objx v0.1.0/go.mod"
	"github.com/stretchr/objx v0.1.1/go.mod"
	"github.com/stretchr/objx v0.4.0/go.mod"
	"github.com/stretchr/objx v0.5.0"
	"github.com/stretchr/objx v0.5.0/go.mod"
	"github.com/stretchr/testify v1.2.2/go.mod"
	"github.com/stretchr/testify v1.3.0/go.mod"
	"github.com/stretchr/testify v1.4.0/go.mod"
	"github.com/stretchr/testify v1.5.1/go.mod"
	"github.com/stretchr/testify v1.6.1/go.mod"
	"github.com/stretchr/testify v1.7.0/go.mod"
	"github.com/stretchr/testify v1.7.1/go.mod"
	"github.com/stretchr/testify v1.8.0/go.mod"
	"github.com/stretchr/testify v1.8.2"
	"github.com/stretchr/testify v1.8.2/go.mod"
	"github.com/syndtr/goleveldb v1.0.0/go.mod"
	"github.com/temoto/robotstxt v1.1.2"
	"github.com/temoto/robotstxt v1.1.2/go.mod"
	"github.com/tv42/httpunix v0.0.0-20150427012821-b75d8614f926/go.mod"
	"github.com/tylertreat/BoomFilters v0.0.0-20210315201527-1a82519a3e43"
	"github.com/tylertreat/BoomFilters v0.0.0-20210315201527-1a82519a3e43/go.mod"
	"github.com/ugorji/go/codec v0.0.0-20181204163529-d75b2dcb6bc8/go.mod"
	"github.com/xordataexchange/crypt v0.0.3-0.20170626215501-b2862e3d0a77/go.mod"
	"github.com/yl2chen/cidranger v1.0.2"
	"github.com/yl2chen/cidranger v1.0.2/go.mod"
	"github.com/yuin/goldmark v1.1.25/go.mod"
	"github.com/yuin/goldmark v1.1.27/go.mod"
	"github.com/yuin/goldmark v1.1.32/go.mod"
	"github.com/yuin/goldmark v1.2.1/go.mod"
	"github.com/yuin/goldmark v1.3.5/go.mod"
	"github.com/yuin/goldmark v1.4.13/go.mod"
	"github.com/yuin/gopher-lua v1.1.0"
	"github.com/yuin/gopher-lua v1.1.0/go.mod"
	"go.etcd.io/etcd/api/v3 v3.5.0/go.mod"
	"go.etcd.io/etcd/client/pkg/v3 v3.5.0/go.mod"
	"go.etcd.io/etcd/client/v2 v2.305.0/go.mod"
	"go.etcd.io/etcd/client/v3 v3.5.0/go.mod"
	"go.opencensus.io v0.21.0/go.mod"
	"go.opencensus.io v0.22.0/go.mod"
	"go.opencensus.io v0.22.2/go.mod"
	"go.opencensus.io v0.22.3/go.mod"
	"go.opencensus.io v0.22.4/go.mod"
	"go.opencensus.io v0.23.0/go.mod"
	"go.opentelemetry.io/proto/otlp v0.7.0/go.mod"
	"go.uber.org/atomic v1.7.0/go.mod"
	"go.uber.org/atomic v1.9.0"
	"go.uber.org/atomic v1.9.0/go.mod"
	"go.uber.org/goleak v1.1.11-0.20210813005559-691160354723/go.mod"
	"go.uber.org/multierr v1.6.0/go.mod"
	"go.uber.org/multierr v1.7.0/go.mod"
	"go.uber.org/ratelimit v0.3.0"
	"go.uber.org/ratelimit v0.3.0/go.mod"
	"go.uber.org/zap v1.17.0/go.mod"
	"go.uber.org/zap v1.19.1/go.mod"
	"golang.org/x/crypto v0.0.0-20180904163835-0709b304e793/go.mod"
	"golang.org/x/crypto v0.0.0-20181029021203-45a5f77698d3/go.mod"
	"golang.org/x/crypto v0.0.0-20181203042331-505ab145d0a9/go.mod"
	"golang.org/x/crypto v0.0.0-20190308221718-c2843e01d9a2/go.mod"
	"golang.org/x/crypto v0.0.0-20190510104115-cbcb75029529/go.mod"
	"golang.org/x/crypto v0.0.0-20190605123033-f99c8df09eb5/go.mod"
	"golang.org/x/crypto v0.0.0-20190923035154-9ee001bba392/go.mod"
	"golang.org/x/crypto v0.0.0-20191011191535-87dc89f01550/go.mod"
	"golang.org/x/crypto v0.0.0-20200323165209-0ec3e9974c59/go.mod"
	"golang.org/x/crypto v0.0.0-20200622213623-75b288015ac9/go.mod"
	"golang.org/x/crypto v0.0.0-20210314154223-e6e6c4f2bb5b/go.mod"
	"golang.org/x/crypto v0.0.0-20210616213533-5ff15b29337e/go.mod"
	"golang.org/x/crypto v0.0.0-20210915214749-c084706c2272/go.mod"
	"golang.org/x/crypto v0.0.0-20210921155107-089bfa567519/go.mod"
	"golang.org/x/crypto v0.13.0"
	"golang.org/x/crypto v0.13.0/go.mod"
	"golang.org/x/exp v0.0.0-20180321215751-8460e604b9de/go.mod"
	"golang.org/x/exp v0.0.0-20180807140117-3d87b88a115f/go.mod"
	"golang.org/x/exp v0.0.0-20190121172915-509febef88a4/go.mod"
	"golang.org/x/exp v0.0.0-20190125153040-c74c464bbbf2/go.mod"
	"golang.org/x/exp v0.0.0-20190306152737-a1d7652674e8/go.mod"
	"golang.org/x/exp v0.0.0-20190510132918-efd6b22b2522/go.mod"
	"golang.org/x/exp v0.0.0-20190829153037-c13cbed26979/go.mod"
	"golang.org/x/exp v0.0.0-20191030013958-a1ab85dbe136/go.mod"
	"golang.org/x/exp v0.0.0-20191129062945-2f5052295587/go.mod"
	"golang.org/x/exp v0.0.0-20191227195350-da58074b4299/go.mod"
	"golang.org/x/exp v0.0.0-20200119233911-0405dc783f0a/go.mod"
	"golang.org/x/exp v0.0.0-20200207192155-f17229e696bd/go.mod"
	"golang.org/x/exp v0.0.0-20200224162631-6cc2880d07d6/go.mod"
	"golang.org/x/image v0.0.0-20180708004352-c73c2afc3b81/go.mod"
	"golang.org/x/image v0.0.0-20190227222117-0694c2d4d067/go.mod"
	"golang.org/x/image v0.0.0-20190802002840-cff245a6509b/go.mod"
	"golang.org/x/lint v0.0.0-20181026193005-c67002cb31c3/go.mod"
	"golang.org/x/lint v0.0.0-20190227174305-5b3e6a55c961/go.mod"
	"golang.org/x/lint v0.0.0-20190301231843-5614ed5bae6f/go.mod"
	"golang.org/x/lint v0.0.0-20190313153728-d0100b6bd8b3/go.mod"
	"golang.org/x/lint v0.0.0-20190409202823-959b441ac422/go.mod"
	"golang.org/x/lint v0.0.0-20190909230951-414d861bb4ac/go.mod"
	"golang.org/x/lint v0.0.0-20190930215403-16217165b5de/go.mod"
	"golang.org/x/lint v0.0.0-20191125180803-fdd1cda4f05f/go.mod"
	"golang.org/x/lint v0.0.0-20200130185559-910be7a94367/go.mod"
	"golang.org/x/lint v0.0.0-20200302205851-738671d3881b/go.mod"
	"golang.org/x/lint v0.0.0-20210508222113-6edffad5e616/go.mod"
	"golang.org/x/mobile v0.0.0-20190312151609-d3739f865fa6/go.mod"
	"golang.org/x/mobile v0.0.0-20190719004257-d2bd2a29d028/go.mod"
	"golang.org/x/mod v0.0.0-20190513183733-4bf6d317e70e/go.mod"
	"golang.org/x/mod v0.1.0/go.mod"
	"golang.org/x/mod v0.1.1-0.20191105210325-c90efee705ee/go.mod"
	"golang.org/x/mod v0.1.1-0.20191107180719-034126e5016b/go.mod"
	"golang.org/x/mod v0.2.0/go.mod"
	"golang.org/x/mod v0.3.0/go.mod"
	"golang.org/x/mod v0.4.2/go.mod"
	"golang.org/x/mod v0.6.0-dev.0.20220419223038-86c51ed26bb4/go.mod"
	"golang.org/x/mod v0.8.0/go.mod"
	"golang.org/x/mod v0.12.0"
	"golang.org/x/mod v0.12.0/go.mod"
	"golang.org/x/net v0.0.0-20180724234803-3673e40ba225/go.mod"
	"golang.org/x/net v0.0.0-20180826012351-8a410e7b638d/go.mod"
	"golang.org/x/net v0.0.0-20180906233101-161cd47e91fd/go.mod"
	"golang.org/x/net v0.0.0-20181023162649-9b4f9f5ad519/go.mod"
	"golang.org/x/net v0.0.0-20181114220301-adae6a3d119a/go.mod"
	"golang.org/x/net v0.0.0-20190108225652-1e06a53dbb7e/go.mod"
	"golang.org/x/net v0.0.0-20190213061140-3a22650c66bd/go.mod"
	"golang.org/x/net v0.0.0-20190311183353-d8887717615a/go.mod"
	"golang.org/x/net v0.0.0-20190404232315-eb5bcb51f2a3/go.mod"
	"golang.org/x/net v0.0.0-20190501004415-9ce7a6920f09/go.mod"
	"golang.org/x/net v0.0.0-20190503192946-f4e77d36d62c/go.mod"
	"golang.org/x/net v0.0.0-20190603091049-60506f45cf65/go.mod"
	"golang.org/x/net v0.0.0-20190613194153-d28f0bde5980/go.mod"
	"golang.org/x/net v0.0.0-20190620200207-3b0461eec859/go.mod"
	"golang.org/x/net v0.0.0-20190628185345-da137c7871d7/go.mod"
	"golang.org/x/net v0.0.0-20190724013045-ca1201d0de80/go.mod"
	"golang.org/x/net v0.0.0-20190923162816-aa69164e4478/go.mod"
	"golang.org/x/net v0.0.0-20191209160850-c0dbc17a3553/go.mod"
	"golang.org/x/net v0.0.0-20200114155413-6afb5195e5aa/go.mod"
	"golang.org/x/net v0.0.0-20200202094626-16171245cfb2/go.mod"
	"golang.org/x/net v0.0.0-20200222125558-5a598a2470a0/go.mod"
	"golang.org/x/net v0.0.0-20200226121028-0de0cce0169b/go.mod"
	"golang.org/x/net v0.0.0-20200301022130-244492dfa37a/go.mod"
	"golang.org/x/net v0.0.0-20200324143707-d3edc9973b7e/go.mod"
	"golang.org/x/net v0.0.0-20200501053045-e0ff5e5a1de5/go.mod"
	"golang.org/x/net v0.0.0-20200506145744-7e3656a0809f/go.mod"
	"golang.org/x/net v0.0.0-20200513185701-a91f0712d120/go.mod"
	"golang.org/x/net v0.0.0-20200520004742-59133d7f0dd7/go.mod"
	"golang.org/x/net v0.0.0-20200520182314-0ba52f642ac2/go.mod"
	"golang.org/x/net v0.0.0-20200625001655-4c5254603344/go.mod"
	"golang.org/x/net v0.0.0-20200707034311-ab3426394381/go.mod"
	"golang.org/x/net v0.0.0-20200822124328-c89045814202/go.mod"
	"golang.org/x/net v0.0.0-20201021035429-f5854403a974/go.mod"
	"golang.org/x/net v0.0.0-20201110031124-69a78807bb2b/go.mod"
	"golang.org/x/net v0.0.0-20210226172049-e18ecbb05110/go.mod"
	"golang.org/x/net v0.0.0-20210405180319-a5a99cb37ef4/go.mod"
	"golang.org/x/net v0.0.0-20210428140749-89ef3d95e781/go.mod"
	"golang.org/x/net v0.0.0-20210525063256-abc453219eb5/go.mod"
	"golang.org/x/net v0.0.0-20210614182718-04defd469f4e/go.mod"
	"golang.org/x/net v0.0.0-20210916014120-12bc252f5db8/go.mod"
	"golang.org/x/net v0.0.0-20210917221730-978cfadd31cf/go.mod"
	"golang.org/x/net v0.0.0-20220127200216-cd36cc0744dd/go.mod"
	"golang.org/x/net v0.0.0-20220225172249-27dd8689420f/go.mod"
	"golang.org/x/net v0.0.0-20220722155237-a158d28d115b/go.mod"
	"golang.org/x/net v0.6.0/go.mod"
	"golang.org/x/net v0.7.0/go.mod"
	"golang.org/x/net v0.9.0/go.mod"
	"golang.org/x/net v0.15.0"
	"golang.org/x/net v0.15.0/go.mod"
	"golang.org/x/oauth2 v0.0.0-20180821212333-d2e6202438be/go.mod"
	"golang.org/x/oauth2 v0.0.0-20190226205417-e64efc72b421/go.mod"
	"golang.org/x/oauth2 v0.0.0-20190604053449-0f29369cfe45/go.mod"
	"golang.org/x/oauth2 v0.0.0-20191202225959-858c2ad4c8b6/go.mod"
	"golang.org/x/oauth2 v0.0.0-20200107190931-bf48bf16ab8d/go.mod"
	"golang.org/x/oauth2 v0.0.0-20210514164344-f6687ab2804c/go.mod"
	"golang.org/x/oauth2 v0.0.0-20220223155221-ee480838109b/go.mod"
	"golang.org/x/sync v0.0.0-20180314180146-1d60e4601c6f/go.mod"
	"golang.org/x/sync v0.0.0-20181108010431-42b317875d0f/go.mod"
	"golang.org/x/sync v0.0.0-20181221193216-37e7f081c4d4/go.mod"
	"golang.org/x/sync v0.0.0-20190227155943-e225da77a7e6/go.mod"
	"golang.org/x/sync v0.0.0-20190423024810-112230192c58/go.mod"
	"golang.org/x/sync v0.0.0-20190911185100-cd5d95a43a6e/go.mod"
	"golang.org/x/sync v0.0.0-20200317015054-43a5402ce75a/go.mod"
	"golang.org/x/sync v0.0.0-20200625203802-6e8e738ad208/go.mod"
	"golang.org/x/sync v0.0.0-20201020160332-67f06af15bc9/go.mod"
	"golang.org/x/sync v0.0.0-20201207232520-09787c993a3a/go.mod"
	"golang.org/x/sync v0.0.0-20210220032951-036812b2e83c/go.mod"
	"golang.org/x/sync v0.0.0-20220722155255-886fb9371eb4/go.mod"
	"golang.org/x/sync v0.1.0/go.mod"
	"golang.org/x/sync v0.3.0"
	"golang.org/x/sys v0.0.0-20180823144017-11551d06cbcc/go.mod"
	"golang.org/x/sys v0.0.0-20180830151530-49385e6e1522/go.mod"
	"golang.org/x/sys v0.0.0-20180905080454-ebe1bf3edb33/go.mod"
	"golang.org/x/sys v0.0.0-20180909124046-d0be0721c37e/go.mod"
	"golang.org/x/sys v0.0.0-20181026203630-95b1ffbd15a5/go.mod"
	"golang.org/x/sys v0.0.0-20181116152217-5ac8a444bdc5/go.mod"
	"golang.org/x/sys v0.0.0-20181205085412-a5c9d58dba9a/go.mod"
	"golang.org/x/sys v0.0.0-20190130150945-aca44879d564/go.mod"
	"golang.org/x/sys v0.0.0-20190215142949-d0b11bdaac8a/go.mod"
	"golang.org/x/sys v0.0.0-20190222072716-a9d3bda3a223/go.mod"
	"golang.org/x/sys v0.0.0-20190312061237-fead79001313/go.mod"
	"golang.org/x/sys v0.0.0-20190412213103-97732733099d/go.mod"
	"golang.org/x/sys v0.0.0-20190422165155-953cdadca894/go.mod"
	"golang.org/x/sys v0.0.0-20190502145724-3ef323f4f1fd/go.mod"
	"golang.org/x/sys v0.0.0-20190507160741-ecd444e8653b/go.mod"
	"golang.org/x/sys v0.0.0-20190606165138-5da285871e9c/go.mod"
	"golang.org/x/sys v0.0.0-20190624142023-c5567b49c5d0/go.mod"
	"golang.org/x/sys v0.0.0-20190626221950-04f50cda93cb/go.mod"
	"golang.org/x/sys v0.0.0-20190726091711-fc99dfbffb4e/go.mod"
	"golang.org/x/sys v0.0.0-20190904154756-749cb33beabd/go.mod"
	"golang.org/x/sys v0.0.0-20190922100055-0a153f010e69/go.mod"
	"golang.org/x/sys v0.0.0-20190924154521-2837fb4f24fe/go.mod"
	"golang.org/x/sys v0.0.0-20191001151750-bb3f8db39f24/go.mod"
	"golang.org/x/sys v0.0.0-20191005200804-aed5e4c7ecf9/go.mod"
	"golang.org/x/sys v0.0.0-20191008105621-543471e840be/go.mod"
	"golang.org/x/sys v0.0.0-20191026070338-33540a1f6037/go.mod"
	"golang.org/x/sys v0.0.0-20191120155948-bd437916bb0e/go.mod"
	"golang.org/x/sys v0.0.0-20191204072324-ce4227a45e2e/go.mod"
	"golang.org/x/sys v0.0.0-20191228213918-04cbcbbfeed8/go.mod"
	"golang.org/x/sys v0.0.0-20200106162015-b016eb3dc98e/go.mod"
	"golang.org/x/sys v0.0.0-20200113162924-86b910548bc1/go.mod"
	"golang.org/x/sys v0.0.0-20200116001909-b77594299b42/go.mod"
	"golang.org/x/sys v0.0.0-20200122134326-e047566fdf82/go.mod"
	"golang.org/x/sys v0.0.0-20200124204421-9fbb57f87de9/go.mod"
	"golang.org/x/sys v0.0.0-20200202164722-d101bd2416d5/go.mod"
	"golang.org/x/sys v0.0.0-20200212091648-12a6c2dcc1e4/go.mod"
	"golang.org/x/sys v0.0.0-20200223170610-d5e6a3e2c0ae/go.mod"
	"golang.org/x/sys v0.0.0-20200302150141-5c8b2ff67527/go.mod"
	"golang.org/x/sys v0.0.0-20200323222414-85ca7c5b95cd/go.mod"
	"golang.org/x/sys v0.0.0-20200331124033-c3d80250170d/go.mod"
	"golang.org/x/sys v0.0.0-20200501052902-10377860bb8e/go.mod"
	"golang.org/x/sys v0.0.0-20200511232937-7e40ca221e25/go.mod"
	"golang.org/x/sys v0.0.0-20200515095857-1151b9dac4a9/go.mod"
	"golang.org/x/sys v0.0.0-20200523222454-059865788121/go.mod"
	"golang.org/x/sys v0.0.0-20200615200032-f1bc736245b1/go.mod"
	"golang.org/x/sys v0.0.0-20200625212154-ddb9806d33ae/go.mod"
	"golang.org/x/sys v0.0.0-20200803210538-64077c9b5642/go.mod"
	"golang.org/x/sys v0.0.0-20200930185726-fdedc70b468f/go.mod"
	"golang.org/x/sys v0.0.0-20201119102817-f84b799fce68/go.mod"
	"golang.org/x/sys v0.0.0-20201207223542-d4d67f95c62d/go.mod"
	"golang.org/x/sys v0.0.0-20210112080510-489259a85091/go.mod"
	"golang.org/x/sys v0.0.0-20210124154548-22da62e12c0c/go.mod"
	"golang.org/x/sys v0.0.0-20210303074136-134d130e1a04/go.mod"
	"golang.org/x/sys v0.0.0-20210330210617-4fbd30eecc44/go.mod"
	"golang.org/x/sys v0.0.0-20210403161142-5e06dd20ab57/go.mod"
	"golang.org/x/sys v0.0.0-20210423082822-04245dca01da/go.mod"
	"golang.org/x/sys v0.0.0-20210510120138-977fb7262007/go.mod"
	"golang.org/x/sys v0.0.0-20210603081109-ebe580a85c40/go.mod"
	"golang.org/x/sys v0.0.0-20210615035016-665e8c7367d1/go.mod"
	"golang.org/x/sys v0.0.0-20210630005230-0f9fa26af87c/go.mod"
	"golang.org/x/sys v0.0.0-20210917161153-d61c044b1678/go.mod"
	"golang.org/x/sys v0.0.0-20211216021012-1d35b9e2eb4e/go.mod"
	"golang.org/x/sys v0.0.0-20220114195835-da31bd327af9/go.mod"
	"golang.org/x/sys v0.0.0-20220520151302-bc2c85ada10a/go.mod"
	"golang.org/x/sys v0.0.0-20220715151400-c0bba94af5f8/go.mod"
	"golang.org/x/sys v0.0.0-20220722155257-8c9f86f7a55f/go.mod"
	"golang.org/x/sys v0.0.0-20220811171246-fbc7d0a398ab/go.mod"
	"golang.org/x/sys v0.0.0-20221010170243-090e33056c14/go.mod"
	"golang.org/x/sys v0.5.0/go.mod"
	"golang.org/x/sys v0.6.0/go.mod"
	"golang.org/x/sys v0.7.0/go.mod"
	"golang.org/x/sys v0.12.0"
	"golang.org/x/sys v0.12.0/go.mod"
	"golang.org/x/term v0.0.0-20201126162022-7de9c90e9dd1/go.mod"
	"golang.org/x/term v0.0.0-20210927222741-03fcf44c2211/go.mod"
	"golang.org/x/term v0.0.0-20220722155259-a9ba230a4035/go.mod"
	"golang.org/x/term v0.5.0/go.mod"
	"golang.org/x/term v0.7.0/go.mod"
	"golang.org/x/term v0.12.0"
	"golang.org/x/text v0.0.0-20170915032832-14c0d48ead0c/go.mod"
	"golang.org/x/text v0.3.0/go.mod"
	"golang.org/x/text v0.3.1-0.20180807135948-17ff2d5776d2/go.mod"
	"golang.org/x/text v0.3.2/go.mod"
	"golang.org/x/text v0.3.3/go.mod"
	"golang.org/x/text v0.3.5/go.mod"
	"golang.org/x/text v0.3.6/go.mod"
	"golang.org/x/text v0.3.7/go.mod"
	"golang.org/x/text v0.3.8/go.mod"
	"golang.org/x/text v0.7.0/go.mod"
	"golang.org/x/text v0.9.0/go.mod"
	"golang.org/x/text v0.13.0"
	"golang.org/x/text v0.13.0/go.mod"
	"golang.org/x/time v0.0.0-20181108054448-85acf8d2951c/go.mod"
	"golang.org/x/time v0.0.0-20190308202827-9d24e82272b4/go.mod"
	"golang.org/x/time v0.0.0-20191024005414-555d28b269f0/go.mod"
	"golang.org/x/time v0.0.0-20200416051211-89c76fbcd5d1/go.mod"
	"golang.org/x/time v0.0.0-20210723032227-1f47c861a9ac/go.mod"
	"golang.org/x/time v0.0.0-20220411224347-583f2d630306/go.mod"
	"golang.org/x/time v0.3.0"
	"golang.org/x/time v0.3.0/go.mod"
	"golang.org/x/tools v0.0.0-20180525024113-a5b4c53f6e8b/go.mod"
	"golang.org/x/tools v0.0.0-20180917221912-90fa682c2a6e/go.mod"
	"golang.org/x/tools v0.0.0-20190114222345-bf090417da8b/go.mod"
	"golang.org/x/tools v0.0.0-20190206041539-40960b6deb8e/go.mod"
	"golang.org/x/tools v0.0.0-20190226205152-f727befe758c/go.mod"
	"golang.org/x/tools v0.0.0-20190311212946-11955173bddd/go.mod"
	"golang.org/x/tools v0.0.0-20190312151545-0bb0c0a6e846/go.mod"
	"golang.org/x/tools v0.0.0-20190312170243-e65039ee4138/go.mod"
	"golang.org/x/tools v0.0.0-20190328211700-ab21143f2384/go.mod"
	"golang.org/x/tools v0.0.0-20190425150028-36563e24a262/go.mod"
	"golang.org/x/tools v0.0.0-20190506145303-2d16b83fe98c/go.mod"
	"golang.org/x/tools v0.0.0-20190524140312-2c0ae7006135/go.mod"
	"golang.org/x/tools v0.0.0-20190606124116-d0a3d012864b/go.mod"
	"golang.org/x/tools v0.0.0-20190621195816-6e04913cbbac/go.mod"
	"golang.org/x/tools v0.0.0-20190628153133-6cdbf07be9d0/go.mod"
	"golang.org/x/tools v0.0.0-20190816200558-6889da9d5479/go.mod"
	"golang.org/x/tools v0.0.0-20190907020128-2ca718005c18/go.mod"
	"golang.org/x/tools v0.0.0-20190911174233-4f2ddba30aff/go.mod"
	"golang.org/x/tools v0.0.0-20191012152004-8de300cfc20a/go.mod"
	"golang.org/x/tools v0.0.0-20191113191852-77e3bb0ad9e7/go.mod"
	"golang.org/x/tools v0.0.0-20191115202509-3a792d9c32b2/go.mod"
	"golang.org/x/tools v0.0.0-20191119224855-298f0cb1881e/go.mod"
	"golang.org/x/tools v0.0.0-20191125144606-a911d9008d1f/go.mod"
	"golang.org/x/tools v0.0.0-20191130070609-6e064ea0cf2d/go.mod"
	"golang.org/x/tools v0.0.0-20191216173652-a0e659d51361/go.mod"
	"golang.org/x/tools v0.0.0-20191227053925-7b8e75db28f4/go.mod"
	"golang.org/x/tools v0.0.0-20200117161641-43d50277825c/go.mod"
	"golang.org/x/tools v0.0.0-20200122220014-bf1340f18c4a/go.mod"
	"golang.org/x/tools v0.0.0-20200130002326-2f3ba24bd6e7/go.mod"
	"golang.org/x/tools v0.0.0-20200204074204-1cc6d1ef6c74/go.mod"
	"golang.org/x/tools v0.0.0-20200207183749-b753a1ba74fa/go.mod"
	"golang.org/x/tools v0.0.0-20200212150539-ea181f53ac56/go.mod"
	"golang.org/x/tools v0.0.0-20200224181240-023911ca70b2/go.mod"
	"golang.org/x/tools v0.0.0-20200227222343-706bc42d1f0d/go.mod"
	"golang.org/x/tools v0.0.0-20200304193943-95d2e580d8eb/go.mod"
	"golang.org/x/tools v0.0.0-20200312045724-11d5b4c81c7d/go.mod"
	"golang.org/x/tools v0.0.0-20200331025713-a30bf2db82d4/go.mod"
	"golang.org/x/tools v0.0.0-20200501065659-ab2804fb9c9d/go.mod"
	"golang.org/x/tools v0.0.0-20200512131952-2bc93b1c0c88/go.mod"
	"golang.org/x/tools v0.0.0-20200515010526-7d3b6ebf133d/go.mod"
	"golang.org/x/tools v0.0.0-20200618134242-20370b0cb4b2/go.mod"
	"golang.org/x/tools v0.0.0-20200619180055-7c47624df98f/go.mod"
	"golang.org/x/tools v0.0.0-20200729194436-6467de6f59a7/go.mod"
	"golang.org/x/tools v0.0.0-20200804011535-6c149bb5ef0d/go.mod"
	"golang.org/x/tools v0.0.0-20200825202427-b303f430e36d/go.mod"
	"golang.org/x/tools v0.0.0-20201224043029-2b0845dc783e/go.mod"
	"golang.org/x/tools v0.0.0-20210106214847-113979e3529a/go.mod"
	"golang.org/x/tools v0.1.2/go.mod"
	"golang.org/x/tools v0.1.5/go.mod"
	"golang.org/x/tools v0.1.12/go.mod"
	"golang.org/x/tools v0.6.0/go.mod"
	"golang.org/x/tools v0.13.0"
	"golang.org/x/tools v0.13.0/go.mod"
	"golang.org/x/xerrors v0.0.0-20190717185122-a985d3407aa7/go.mod"
	"golang.org/x/xerrors v0.0.0-20191011141410-1b5146add898/go.mod"
	"golang.org/x/xerrors v0.0.0-20191204190536-9bdfabe68543/go.mod"
	"golang.org/x/xerrors v0.0.0-20200804184101-5ec99f83aff1/go.mod"
	"gonum.org/v1/gonum v0.0.0-20180816165407-929014505bf4/go.mod"
	"gonum.org/v1/gonum v0.8.2/go.mod"
	"gonum.org/v1/netlib v0.0.0-20190313105609-8cb42192e0e0/go.mod"
	"gonum.org/v1/plot v0.0.0-20190515093506-e2840ee46a6b/go.mod"
	"google.golang.org/api v0.4.0/go.mod"
	"google.golang.org/api v0.7.0/go.mod"
	"google.golang.org/api v0.8.0/go.mod"
	"google.golang.org/api v0.9.0/go.mod"
	"google.golang.org/api v0.13.0/go.mod"
	"google.golang.org/api v0.14.0/go.mod"
	"google.golang.org/api v0.15.0/go.mod"
	"google.golang.org/api v0.17.0/go.mod"
	"google.golang.org/api v0.18.0/go.mod"
	"google.golang.org/api v0.19.0/go.mod"
	"google.golang.org/api v0.20.0/go.mod"
	"google.golang.org/api v0.22.0/go.mod"
	"google.golang.org/api v0.24.0/go.mod"
	"google.golang.org/api v0.28.0/go.mod"
	"google.golang.org/api v0.29.0/go.mod"
	"google.golang.org/api v0.30.0/go.mod"
	"google.golang.org/appengine v1.1.0/go.mod"
	"google.golang.org/appengine v1.4.0/go.mod"
	"google.golang.org/appengine v1.5.0/go.mod"
	"google.golang.org/appengine v1.6.1/go.mod"
	"google.golang.org/appengine v1.6.5/go.mod"
	"google.golang.org/appengine v1.6.6/go.mod"
	"google.golang.org/genproto v0.0.0-20180817151627-c66870c02cf8/go.mod"
	"google.golang.org/genproto v0.0.0-20190307195333-5fe7a883aa19/go.mod"
	"google.golang.org/genproto v0.0.0-20190418145605-e7d98fc518a7/go.mod"
	"google.golang.org/genproto v0.0.0-20190425155659-357c62f0e4bb/go.mod"
	"google.golang.org/genproto v0.0.0-20190502173448-54afdca5d873/go.mod"
	"google.golang.org/genproto v0.0.0-20190801165951-fa694d86fc64/go.mod"
	"google.golang.org/genproto v0.0.0-20190819201941-24fa4b261c55/go.mod"
	"google.golang.org/genproto v0.0.0-20190911173649-1774047e7e51/go.mod"
	"google.golang.org/genproto v0.0.0-20191108220845-16a3f7862a1a/go.mod"
	"google.golang.org/genproto v0.0.0-20191115194625-c23dd37a84c9/go.mod"
	"google.golang.org/genproto v0.0.0-20191216164720-4f79533eabd1/go.mod"
	"google.golang.org/genproto v0.0.0-20191230161307-f3c370f40bfb/go.mod"
	"google.golang.org/genproto v0.0.0-20200115191322-ca5a22157cba/go.mod"
	"google.golang.org/genproto v0.0.0-20200122232147-0452cf42e150/go.mod"
	"google.golang.org/genproto v0.0.0-20200204135345-fa8e72b47b90/go.mod"
	"google.golang.org/genproto v0.0.0-20200212174721-66ed5ce911ce/go.mod"
	"google.golang.org/genproto v0.0.0-20200224152610-e50cd9704f63/go.mod"
	"google.golang.org/genproto v0.0.0-20200228133532-8c2c7df3a383/go.mod"
	"google.golang.org/genproto v0.0.0-20200305110556-506484158171/go.mod"
	"google.golang.org/genproto v0.0.0-20200312145019-da6875a35672/go.mod"
	"google.golang.org/genproto v0.0.0-20200331122359-1ee6d9798940/go.mod"
	"google.golang.org/genproto v0.0.0-20200430143042-b979b6f78d84/go.mod"
	"google.golang.org/genproto v0.0.0-20200511104702-f5ebc3bea380/go.mod"
	"google.golang.org/genproto v0.0.0-20200513103714-09dca8ec2884/go.mod"
	"google.golang.org/genproto v0.0.0-20200515170657-fc4c6c6a6587/go.mod"
	"google.golang.org/genproto v0.0.0-20200526211855-cb27e3aa2013/go.mod"
	"google.golang.org/genproto v0.0.0-20200618031413-b414f8b61790/go.mod"
	"google.golang.org/genproto v0.0.0-20200729003335-053ba62fc06f/go.mod"
	"google.golang.org/genproto v0.0.0-20200804131852-c06518451d9c/go.mod"
	"google.golang.org/genproto v0.0.0-20200825200019-8632dd797987/go.mod"
	"google.golang.org/genproto v0.0.0-20210602131652-f16073e35f0c/go.mod"
	"google.golang.org/genproto v0.0.0-20210917145530-b395a37504d4/go.mod"
	"google.golang.org/grpc v1.19.0/go.mod"
	"google.golang.org/grpc v1.20.1/go.mod"
	"google.golang.org/grpc v1.21.1/go.mod"
	"google.golang.org/grpc v1.23.0/go.mod"
	"google.golang.org/grpc v1.25.1/go.mod"
	"google.golang.org/grpc v1.26.0/go.mod"
	"google.golang.org/grpc v1.27.0/go.mod"
	"google.golang.org/grpc v1.27.1/go.mod"
	"google.golang.org/grpc v1.28.0/go.mod"
	"google.golang.org/grpc v1.29.1/go.mod"
	"google.golang.org/grpc v1.30.0/go.mod"
	"google.golang.org/grpc v1.31.0/go.mod"
	"google.golang.org/grpc v1.33.1/go.mod"
	"google.golang.org/grpc v1.33.2/go.mod"
	"google.golang.org/grpc v1.36.0/go.mod"
	"google.golang.org/grpc v1.38.0/go.mod"
	"google.golang.org/grpc v1.40.0/go.mod"
	"google.golang.org/protobuf v0.0.0-20200109180630-ec00e32a8dfd/go.mod"
	"google.golang.org/protobuf v0.0.0-20200221191635-4d8936d0db64/go.mod"
	"google.golang.org/protobuf v0.0.0-20200228230310-ab0ca4ff8a60/go.mod"
	"google.golang.org/protobuf v1.20.1-0.20200309200217-e05f789c0967/go.mod"
	"google.golang.org/protobuf v1.21.0/go.mod"
	"google.golang.org/protobuf v1.22.0/go.mod"
	"google.golang.org/protobuf v1.23.0/go.mod"
	"google.golang.org/protobuf v1.23.1-0.20200526195155-81db48ad09cc/go.mod"
	"google.golang.org/protobuf v1.24.0/go.mod"
	"google.golang.org/protobuf v1.25.0/go.mod"
	"google.golang.org/protobuf v1.26.0-rc.1/go.mod"
	"google.golang.org/protobuf v1.26.0/go.mod"
	"google.golang.org/protobuf v1.27.1/go.mod"
	"google.golang.org/protobuf v1.28.0/go.mod"
	"google.golang.org/protobuf v1.31.0"
	"google.golang.org/protobuf v1.31.0/go.mod"
	"gopkg.in/alecthomas/kingpin.v2 v2.2.6/go.mod"
	"gopkg.in/check.v1 v0.0.0-20161208181325-20d25e280405/go.mod"
	"gopkg.in/check.v1 v1.0.0-20180628173108-788fd7840127/go.mod"
	"gopkg.in/check.v1 v1.0.0-20190902080502-41f04d3bba15/go.mod"
	"gopkg.in/check.v1 v1.0.0-20200227125254-8fa46927fb4f/go.mod"
	"gopkg.in/check.v1 v1.0.0-20201130134442-10cb98267c6c"
	"gopkg.in/errgo.v2 v2.1.0/go.mod"
	"gopkg.in/fsnotify.v1 v1.4.7/go.mod"
	"gopkg.in/gcfg.v1 v1.2.3/go.mod"
	"gopkg.in/tomb.v1 v1.0.0-20141024135613-dd632973f1e7/go.mod"
	"gopkg.in/warnings.v0 v0.1.2/go.mod"
	"gopkg.in/yaml.v2 v2.2.1/go.mod"
	"gopkg.in/yaml.v2 v2.2.2/go.mod"
	"gopkg.in/yaml.v2 v2.2.3/go.mod"
	"gopkg.in/yaml.v2 v2.2.4/go.mod"
	"gopkg.in/yaml.v2 v2.2.5/go.mod"
	"gopkg.in/yaml.v2 v2.2.8/go.mod"
	"gopkg.in/yaml.v2 v2.3.0/go.mod"
	"gopkg.in/yaml.v2 v2.4.0/go.mod"
	"gopkg.in/yaml.v3 v3.0.0-20200313102051-9f266ea9e77c/go.mod"
	"gopkg.in/yaml.v3 v3.0.0-20210107192922-496545a6307b/go.mod"
	"gopkg.in/yaml.v3 v3.0.1"
	"gopkg.in/yaml.v3 v3.0.1/go.mod"
	"gorm.io/datatypes v1.2.0"
	"gorm.io/datatypes v1.2.0/go.mod"
	"gorm.io/driver/mysql v1.5.1"
	"gorm.io/driver/mysql v1.5.1/go.mod"
	"gorm.io/driver/postgres v1.5.2"
	"gorm.io/driver/postgres v1.5.2/go.mod"
	"gorm.io/driver/sqlite v1.5.2"
	"gorm.io/driver/sqlserver v1.4.1"
	"gorm.io/gorm v1.25.1/go.mod"
	"gorm.io/gorm v1.25.4"
	"gorm.io/gorm v1.25.4/go.mod"
	"honnef.co/go/tools v0.0.0-20190102054323-c2f93a96b099/go.mod"
	"honnef.co/go/tools v0.0.0-20190106161140-3f1c8253044a/go.mod"
	"honnef.co/go/tools v0.0.0-20190418001031-e561f6794a2a/go.mod"
	"honnef.co/go/tools v0.0.0-20190523083050-ea95bdfd59fc/go.mod"
	"honnef.co/go/tools v0.0.1-2019.2.3/go.mod"
	"honnef.co/go/tools v0.0.1-2020.1.3/go.mod"
	"honnef.co/go/tools v0.0.1-2020.1.4/go.mod"
	"layeh.com/gopher-json v0.0.0-20201124131017-552bb3c4c3bf"
	"layeh.com/gopher-json v0.0.0-20201124131017-552bb3c4c3bf/go.mod"
	"modernc.org/libc v1.24.1"
	"modernc.org/libc v1.24.1/go.mod"
	"modernc.org/mathutil v1.6.0"
	"modernc.org/mathutil v1.6.0/go.mod"
	"modernc.org/memory v1.7.1"
	"modernc.org/memory v1.7.1/go.mod"
	"modernc.org/sqlite v1.25.0"
	"modernc.org/sqlite v1.25.0/go.mod"
	"rsc.io/binaryregexp v0.2.0/go.mod"
	"rsc.io/pdf v0.1.1/go.mod"
	"rsc.io/quote/v3 v3.1.0/go.mod"
	"rsc.io/sampler v1.3.0/go.mod"
	"sigs.k8s.io/yaml v1.2.0/go.mod"
	)
go-module_set_globals

DESCRIPTION="Subdomain OSINT Enumeration"
HOMEPAGE="https://github.com/OWASP/Amass"

SRC_URI="https://github.com/OWASP/Amass/archive/v${PV}.tar.gz -> ${P}.gh.tar.gz
	${EGO_SUM_SRC_URI}"

LICENSE="Apache-2.0"
SLOT="0"
KEYWORDS="amd64 ~arm64 x86"

BDEPEND=">=dev-lang/go-1.13"

src_compile() {
	env GOBIN="${S}/bin" go install ./... || die "compile failed"
}

src_install() {
	dobin bin/${PN}
}
