// Ripped from https://github.com/Ch0pin/medusa/ and modified to fit Androguard packets

colorLog('[+] LOADING INTENTS/INTENTS.JS',{c: Color.Red});

var uri = Java.use('android.net.Uri'); 
var intent1 = Java.use('android.content.Intent');
var bundle1 = Java.use('android.os.Bundle');

uri.getQueryParameter.implementation = function(key){
    var ret = this.getQueryParameter(key);
    agPacket({intent: dumpIntent(this), ret: ret, key: key}).send();
    return ret;
}

uri.getQueryParameters.implementation = function(key){
    var ret = this.getQueryParameters(key);
    agPacket({intent: dumpIntent(this), ret: ret, key: key}).send();
    return ret;
}

bundle1.getByte.overloads[0].implementation = function(key){
    var ret = this.getByte(key);
    agPacket({intent: dumpIntent(this), ret: ret, key: key}).send();
    return ret;
}
bundle1.getByte.overloads[1].implementation = function(key,def){
    var ret = this.getByte(key, def);
    agPacket({intent: dumpIntent(this), ret: ret, key: key, def: def}).send();
    return ret;
}

bundle1.getChar.overloads[0].implementation = function(key){
    var ret = this.getChar(key);
    agPacket({intent: dumpIntent(this), ret: ret, key: key}).send();
    return ret;
}
bundle1.getChar.overloads[1].implementation = function(key,def){
    var ret = this.getChar(key, def);
    agPacket({intent: dumpIntent(this), ret: ret, key: key, def: def}).send();
    return ret;
}

bundle1.getCharSequence.overloads[0].implementation = function(key){
    var ret = this.getCharSequence(key);
    agPacket({intent: dumpIntent(this), ret: ret, key: key}).send();
    return ret;
}
bundle1.getCharSequence.overloads[1].implementation = function(key, def){
    var ret = this.getCharSequence(key, def);
    agPacket({intent: dumpIntent(this), ret: ret, key: key, def: def}).send();
    return ret;
}

bundle1.getFloat.overloads[0].implementation = function(key){
    var ret = this.getFloat(key);
    agPacket({intent: dumpIntent(this), ret: ret, key: key}).send();
    return ret;
}
bundle1.getFloat.overloads[1].implementation = function(key, def){
    var ret = this.getFloat(key,def);
    agPacket({intent: dumpIntent(this), ret: ret, key: key, def: def}).send();
    return ret;
}

bundle1.getShort.overloads[0].implementation = function(key){
    var ret = this.getShort(key);
    agPacket({intent: dumpIntent(this), ret: ret, key: key}).send();
    return ret;
}
bundle1.getShort.overloads[1].implementation = function(key, def){
    var ret = this.getShort(key,def);
    agPacket({intent: dumpIntent(this), ret: ret, key: key, def: def}).send();
    return ret;
}
intent1.getSerializableExtra.implementation = function(name){
    agPacket({intent: dumpIntent(this), name: name}).send();
    return this.getSerializableExtra(name);
}

intent1.getParcelableExtra.implementation = function(name){
    agPacket({intent: dumpIntent(this), name: name}).send();
    return this.getParcelableExtra(name);
}

if(Java.androidVersion > 12)
intent1.getParcelableExtra.overload('java.lang.String', 'java.lang.Class').implementation = function(name,clazz){
    let ret = this.getParcelableExtra(name,clazz);
    agPacket({intent: dumpIntent(this), name: name, ret: ret}).send();
    return ret;
}

intent1.getBooleanExtra.implementation = function(name, value){
    var ret = this.getBooleanExtra(name,value);
    agPacket({intent: dumpIntent(this), ret: ret, name: name, value: value}).send();
    return ret;
}

intent1.getBundleExtra.implementation = function(bundlename){
    agPacket({intent: dumpIntent(this), bundlename: bundlename}).send();
    return this.getBundleExtra(bundlename);
}

intent1.getByteArrayExtra.implementation = function(name){
    var ret = this.getByteArrayExtra(name);
    agPacket({intent: dumpIntent(this), ret: ret, name: name}).send();
    return ret;
}

intent1.getByteExtra.implementation = function(name,value){
    var ret = this.getByteExtra(name,value);
    agPacket({intent: dumpIntent(this), ret: ret, name: name, value: value}).send();
    return ret;
}

intent1.getCharArrayExtra.implementation = function(name){
    var ret = this.getCharArrayExtra(name);
    agPacket({intent: dumpIntent(this), ret: ret, name: name}).send();
    return ret;
}

intent1.getCharExtra.implementation = function(name,value){
    var ret =  this.getCharExtra(name, value);
    agPacket({intent: dumpIntent(this), ret: ret, name: name, value: value}).send();
    return ret;
}

intent1.getData.implementation = function(){
    var ret = this.getData();
    agPacket({intent: dumpIntent(this), ret: ret}).send();
    return ret;

}

intent1.getDataString.implementation = function(){
    var ret = this.getDataString();
    agPacket({intent: dumpIntent(this), ret: ret}).send();
    return ret;
}

intent1.getDoubleArrayExtra.implementation = function(name){
    var ret = this.getDoubleArrayExtra(name);
    agPacket({intent: dumpIntent(this), ret: ret, name: name}).send();
    return ret;
}

intent1.getDoubleExtra.implementation = function(name,value){
    var ret =  this.getDoubleExtra(name,value);
    agPacket({intent: dumpIntent(this), ret: ret, name: name, value: value}).send();
    return ret;
}

intent1.getStringExtra.implementation = function(name){
    var ret =  this.getStringExtra(name);
    agPacket({intent: dumpIntent(this), ret: ret, name: name}).send();
    return ret;
}

intent1.getPackage.implementation = function(){
    var ret =  this.getPackage();
    agPacket({intent: dumpIntent(this), ret: ret}).send();
    return ret;
}